/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.asn1.v1_1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import net.heberling.ismart.asn1.AbstractMessageCoder;
import net.heberling.ismart.asn1.v1_1.DataEncodingType;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherBody;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherHeader;
import net.heberling.ismart.asn1.v1_1.Message;
import org.bn.coders.IASN1PreparedElement;

public class MessageCoder<E extends IASN1PreparedElement>
extends AbstractMessageCoder<MP_DispatcherHeader, MP_DispatcherBody, E, Message<E>> {
    public MessageCoder(Class<E> applicationDataClass) {
        super(applicationDataClass);
    }

    @Override
    public String encodeRequest(Message<E> message) {
        Object request = message.getApplicationData();
        try {
            byte[] applicationData;
            ByteArrayOutputStream bos;
            AbstractMessageCoder.MyPERUnalignedEncoder encoder = new AbstractMessageCoder.MyPERUnalignedEncoder();
            if (request != null) {
                bos = new ByteArrayOutputStream();
                encoder.encode(request, bos);
                applicationData = bos.toByteArray();
            } else {
                applicationData = new byte[]{};
            }
            MP_DispatcherBody body = (MP_DispatcherBody)message.getBody();
            DataEncodingType dataEncoding = new DataEncodingType();
            dataEncoding.setValue(DataEncodingType.EnumType.perUnaligned);
            body.setApplicationDataEncoding(dataEncoding);
            body.setApplicationDataLength(Long.valueOf(applicationData.length));
            bos = new ByteArrayOutputStream();
            encoder.encode(body, bos);
            byte[] bodyData = bos.toByteArray();
            MP_DispatcherHeader header = (MP_DispatcherHeader)message.getHeader();
            if (header.getProtocolVersion() == null) {
                header.setProtocolVersion(17);
            }
            if (header.getSecurityContext() == null) {
                header.setSecurityContext(0);
            }
            header.setDispatcherMessageLength(bodyData.length + 4);
            header.setDispatcherBodyEncoding(0);
            bos = new ByteArrayOutputStream();
            bos.write(header.getProtocolVersion());
            bos.write(header.getSecurityContext());
            bos.write(header.getDispatcherMessageLength());
            bos.write(header.getDispatcherBodyEncoding());
            bos.write(bodyData);
            bos.write(applicationData);
            byte[] bytes = bos.toByteArray();
            return String.format("%04X", bytes.length * 2 + 5) + "1" + MessageCoder.bytesToHex(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Message<E> decodeResponse(String message) {
        try {
            byte[] bytes = MessageCoder.hexStringToByteArray(message.substring(5));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            MP_DispatcherHeader header = new MP_DispatcherHeader();
            header.setProtocolVersion(((InputStream)inputStream).read());
            header.setSecurityContext(((InputStream)inputStream).read());
            header.setDispatcherMessageLength(((InputStream)inputStream).read());
            header.setDispatcherBodyEncoding(((InputStream)inputStream).read());
            byte[] b = new byte[header.getDispatcherMessageLength() - 4];
            inputStream.read(b);
            AbstractMessageCoder.MyPERUnalignedDecoder decoder = new AbstractMessageCoder.MyPERUnalignedDecoder();
            MP_DispatcherBody body = (MP_DispatcherBody)decoder.decode(new ByteArrayInputStream(b), MP_DispatcherBody.class);
            IASN1PreparedElement e = null;
            if (body.getApplicationDataLength() > 0L) {
                byte[] appData = new byte[body.getApplicationDataLength().intValue()];
                inputStream.read(appData);
                e = (IASN1PreparedElement)decoder.decode(new ByteArrayInputStream(appData), this.getApplicationDataClass());
            }
            return new Message<Object>(header, body, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decode: " + message, e);
        }
    }

    @Override
    public String getVersion() {
        return "1.1";
    }
}

