/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.variable;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.heberling.clanlord.macro.interpreter.variable.LiteralVariable;
import net.heberling.clanlord.macro.interpreter.variable.Variable;

public class VariableStorage {
    private static final Pattern NUM_LETTERS = Pattern.compile("(.*)\\.num_letters");
    private static final Pattern LETTER = Pattern.compile("(.*)\\.letter\\[(.*)]");
    private static final Pattern NUM_WORDS = Pattern.compile("(.*)\\.num_words");
    private static final Pattern WORD = Pattern.compile("(.*)\\.word\\[(.*)]");
    private static final VariableStorage GLOBAL_STORAGE = new VariableStorage();
    private final HashMap<String, Variable> localVars = new HashMap();

    public Variable get(String key) {
        String action = "None";
        int index = 0;
        Matcher matcher = NUM_LETTERS.matcher(key);
        if (matcher.matches()) {
            key = matcher.group(1);
            action = "num_letters";
        } else {
            matcher = LETTER.matcher(key);
            if (matcher.matches()) {
                key = matcher.group(1);
                index = Integer.parseInt(matcher.group(2));
                action = "letter";
            } else {
                matcher = NUM_WORDS.matcher(key);
                if (matcher.matches()) {
                    key = matcher.group(1);
                    action = "num_words";
                } else {
                    matcher = WORD.matcher(key);
                    if (matcher.matches()) {
                        key = matcher.group(1);
                        index = Integer.parseInt(matcher.group(2));
                        action = "word";
                    }
                }
            }
        }
        Variable variable = this._get(key);
        switch (action) {
            case "num_letters": {
                variable = variable.getLetterCount();
                break;
            }
            case "letter": {
                variable = variable.getLetter(index);
                break;
            }
            case "num_words": {
                variable = variable.getWordCount();
                break;
            }
            case "word": {
                variable = variable.getWord(index);
                break;
            }
        }
        return variable;
    }

    private Variable _get(String key) {
        String keyLower = key.toLowerCase();
        Variable variable = null;
        if (this.localVars.containsKey(keyLower)) {
            variable = this.localVars.get(keyLower);
        } else if (this != GLOBAL_STORAGE) {
            variable = GLOBAL_STORAGE.get(key);
        }
        if (variable == null) {
            variable = new LiteralVariable(key);
        }
        if (!variable.isNumeric() && variable.getWordCount().asNumber() == 1 && variable.getLetterCount().asNumber() > 0 && !keyLower.equals(variable.asString().toLowerCase())) {
            variable = this._get(variable.asString());
        }
        return variable;
    }

    public void put(String key, Variable value) {
        key = key.toLowerCase();
        this.localVars.put(key, value);
    }

    public static VariableStorage getGlobalStorage() {
        return GLOBAL_STORAGE;
    }

    public void clear() {
        this.localVars.clear();
    }
}

