/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.variable;

import net.heberling.clanlord.macro.interpreter.variable.EmptyVariable;
import net.heberling.clanlord.macro.interpreter.variable.LiteralVariable;

public abstract class Variable {
    private String[] words;

    public abstract String asString();

    public abstract int asNumber();

    public abstract boolean isNumeric();

    public Variable getWordCount() {
        if (this.words == null) {
            this.words = this.asString().split(" ");
        }
        return new LiteralVariable(this.words.length);
    }

    public Variable getWord(int word) {
        int wordCount = this.getWordCount().asNumber();
        if (word >= 0 && word < wordCount) {
            return new LiteralVariable(this.words[word]);
        }
        return EmptyVariable.INSTANCE;
    }

    public Variable getLetterCount() {
        return new LiteralVariable(this.asString().length());
    }

    public Variable getLetter(int letter) {
        if (letter >= 0 && letter < this.asString().length()) {
            return new LiteralVariable(String.valueOf(this.asString().charAt(letter)));
        }
        return EmptyVariable.INSTANCE;
    }
}

