/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.variable;

import net.heberling.clanlord.macro.interpreter.variable.Variable;

public class LiteralVariable
extends Variable {
    private final String content;
    private Integer number;

    public LiteralVariable(int content) {
        this.content = String.valueOf(content);
        this.number = content;
    }

    public LiteralVariable(String content) {
        this.content = content;
        try {
            this.number = Integer.parseInt(content);
        }
        catch (NumberFormatException e) {
            this.number = null;
        }
    }

    @Override
    public String asString() {
        return this.content;
    }

    @Override
    public int asNumber() {
        if (!this.isNumeric()) {
            throw new IllegalStateException(this.content + " is not numeric");
        }
        return this.number;
    }

    @Override
    public boolean isNumeric() {
        return this.number != null;
    }
}

