/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.node;

import net.heberling.clanlord.macro.interpreter.node.AbstractMacroNode;
import net.heberling.clanlord.macro.interpreter.node.AbstractTerminalMacroNode;
import net.heberling.clanlord.macro.interpreter.variable.LiteralVariable;
import net.heberling.clanlord.macro.interpreter.variable.Variable;
import net.heberling.clanlord.macro.interpreter.variable.VariableStorage;
import net.heberling.clanlord.macro.parser.MacroParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMacroNode
extends AbstractTerminalMacroNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMacroNode.class);
    private final String identifier;
    private final MacroParser.ValueContext value;
    private final boolean global;
    private final MacroParser.OperatorContext operator;

    public SetMacroNode(String identifier, boolean global, MacroParser.Set_expressionContext setExpression) {
        this(identifier, global, setExpression.operator(), setExpression.value());
    }

    public SetMacroNode(String identifier, boolean global, MacroParser.OperatorContext operator, MacroParser.ValueContext value) {
        this.identifier = identifier;
        this.global = global;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public AbstractMacroNode.Result tick() {
        Variable newValue = this.getValue(this.value);
        Variable oldValue = this.getVariableStorage().get(this.identifier);
        (this.global ? VariableStorage.getGlobalStorage() : this.getVariableStorage()).put(this.identifier, this.calculateValue(this.operator, oldValue, newValue));
        return new AbstractMacroNode.Result(true, 0, null, null);
    }

    private Variable calculateValue(MacroParser.OperatorContext operator, Variable oldValue, Variable newValue) {
        LOGGER.debug(oldValue + " " + operator + " " + newValue);
        if (operator == null) {
            return newValue;
        }
        if (oldValue.isNumeric()) {
            if (newValue.isNumeric()) {
                switch (operator.getText()) {
                    case "+": {
                        return new LiteralVariable(oldValue.asNumber() + newValue.asNumber());
                    }
                    case "-": {
                        return new LiteralVariable(oldValue.asNumber() - newValue.asNumber());
                    }
                    case "*": {
                        return new LiteralVariable(oldValue.asNumber() * newValue.asNumber());
                    }
                    case "/": {
                        return new LiteralVariable(oldValue.asNumber() / newValue.asNumber());
                    }
                    case "%": {
                        return new LiteralVariable(oldValue.asNumber() % newValue.asNumber());
                    }
                }
                throw new IllegalArgumentException("Unknown Operator " + operator.getText());
            }
            throw new IllegalArgumentException("Value " + newValue.asString() + " is not a number");
        }
        if (!operator.getText().equals("+")) {
            throw new IllegalArgumentException("Can't use " + operator.getText() + " with strings");
        }
        return new LiteralVariable(oldValue.asString() + newValue.asString());
    }

    @Override
    public String toString() {
        return (this.global ? "setglobal " : "set ") + this.identifier + " " + (this.operator != null ? this.operator.getText().trim() + " " : "") + (this.value != null ? this.value.getText() : "<null>");
    }

    @Override
    public AbstractMacroNode copy(AbstractMacroNode newParent) {
        SetMacroNode setMacroNode = new SetMacroNode(this.identifier, this.global, this.operator, this.value);
        setMacroNode.setParent(newParent);
        return setMacroNode;
    }
}

