/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.node;

import net.heberling.clanlord.macro.interpreter.node.AbstractMacroNode;
import net.heberling.clanlord.macro.interpreter.node.AbstractSequenceMacroNode;
import net.heberling.clanlord.macro.interpreter.node.LabelMacroNode;

public class SequenceMacroNode
extends AbstractSequenceMacroNode {
    private int currentIndex = 0;
    private AbstractMacroNode.Result currentNode;

    public SequenceMacroNode(String name) {
        super(name);
    }

    @Override
    public AbstractMacroNode.Result tick() {
        String label;
        String text;
        int waitFrames;
        boolean finished;
        if (this.statements.isEmpty()) {
            return new AbstractMacroNode.Result(true, 0, null, null);
        }
        if (this.statements.size() == 1) {
            return ((AbstractMacroNode)this.statements.get(0)).tick();
        }
        do {
            if (this.currentNode == null) {
                this.currentNode = ((AbstractMacroNode)this.statements.get(this.currentIndex)).tick();
            }
            finished = this.currentNode.isFinished();
            waitFrames = this.currentNode.getWaitFrames();
            text = this.currentNode.getText();
            label = this.currentNode.getLabel();
            if (!finished) continue;
            if (label == null) {
                ++this.currentIndex;
            } else {
                String finalLabel = label;
                LabelMacroNode labelMacroNode = this.statements.stream().filter(l -> l instanceof LabelMacroNode).map(LabelMacroNode.class::cast).filter(l -> l.getName().equals(finalLabel)).findFirst().orElse(null);
                if (labelMacroNode == null) {
                    this.currentIndex = Integer.MAX_VALUE;
                } else {
                    for (int i = this.currentIndex = this.statements.indexOf(labelMacroNode); i < this.statements.size(); ++i) {
                        this.statements.set(i, ((AbstractMacroNode)this.statements.get(i)).copy(this));
                    }
                    label = null;
                }
            }
            if (this.currentIndex >= this.statements.size()) {
                this.currentIndex = 0;
                finished = true;
            } else {
                finished = false;
            }
            this.currentNode = null;
        } while (!finished && waitFrames <= 0 && text == null);
        this.currentNode = null;
        return new AbstractMacroNode.Result(finished, waitFrames, text, label);
    }

    @Override
    public AbstractMacroNode copy(AbstractMacroNode newParent) {
        SequenceMacroNode sequenceMacroNode = new SequenceMacroNode(this.getName());
        sequenceMacroNode.setParent(newParent);
        this.statements.forEach(s -> sequenceMacroNode.addChildMacroNode(s.copy(sequenceMacroNode)));
        return sequenceMacroNode;
    }
}

