/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.node;

import java.util.Random;
import net.heberling.clanlord.macro.interpreter.node.AbstractMacroNode;
import net.heberling.clanlord.macro.interpreter.node.AbstractSequenceMacroNode;

public class RandomStatementMacroNode
extends AbstractSequenceMacroNode {
    private static final Random random = new Random();
    private int lastChosen = -1;
    private int currentChosen = -1;
    private boolean noRepeat;

    public RandomStatementMacroNode(boolean noRepeat) {
        super("random");
        this.noRepeat = noRepeat;
    }

    @Override
    public AbstractMacroNode.Result tick() {
        if (this.statements.size() > 1) {
            AbstractMacroNode.Result result;
            if (this.currentChosen == -1) {
                do {
                    this.currentChosen = random.nextInt(this.statements.size());
                } while (this.noRepeat && this.currentChosen == this.lastChosen);
                this.lastChosen = this.currentChosen;
            }
            if ((result = ((AbstractMacroNode)this.statements.get(this.currentChosen)).tick()).isFinished()) {
                this.currentChosen = -1;
            }
            return result;
        }
        if (this.statements.size() == 1) {
            return ((AbstractMacroNode)this.statements.get(0)).tick();
        }
        return new AbstractMacroNode.Result(true, 0, null, null);
    }

    @Override
    public AbstractMacroNode copy(AbstractMacroNode newParent) {
        RandomStatementMacroNode randomStatementMacroNode = new RandomStatementMacroNode(this.noRepeat);
        randomStatementMacroNode.setParent(newParent);
        randomStatementMacroNode.currentChosen = this.currentChosen;
        this.statements.forEach(s -> randomStatementMacroNode.addChildMacroNode(s.copy(randomStatementMacroNode)));
        return randomStatementMacroNode;
    }
}

