/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.node;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import net.heberling.clanlord.macro.interpreter.node.AbstractMacroNode;
import net.heberling.clanlord.macro.interpreter.variable.VariableStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroMacroNode
extends AbstractMacroNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroMacroNode.class);
    private final String trigger;
    private final VariableStorage variableStorage = new VariableStorage();
    private AbstractMacroNode statement;
    private boolean activated;
    private boolean needsCleanup;
    private int waitFrames;
    private final Set<Attribute> attributes = EnumSet.noneOf(Attribute.class);

    public MacroMacroNode(String trigger) {
        this.trigger = trigger;
    }

    public String getTrigger() {
        return this.trigger;
    }

    @Override
    public AbstractMacroNode.Result tick() {
        LOGGER.trace(this + " got ticked.");
        if (this.isActivated()) {
            AbstractMacroNode.Result ret;
            if (--this.waitFrames > 0) {
                return new AbstractMacroNode.Result(false, this.waitFrames, null, null);
            }
            StringBuilder text = null;
            do {
                ret = this.statement.tick();
                this.waitFrames = ret.waitFrames;
                if (ret.getLabel() != null) {
                    throw new IllegalStateException("Could not find label " + ret.getLabel());
                }
                if (ret.isFinished()) {
                    this.deactivate();
                }
                if (ret.getText() == null) continue;
                if (text == null) {
                    text = new StringBuilder(ret.getText());
                    continue;
                }
                text.append(ret.getText());
            } while (!ret.isFinished() && ret.waitFrames <= 0);
            return new AbstractMacroNode.Result(ret.isFinished(), ret.waitFrames, text == null ? null : text.toString(), null);
        }
        return new AbstractMacroNode.Result(true, 0, null, null);
    }

    public AbstractMacroNode getStatement() {
        return this.statement;
    }

    public void setStatement(AbstractMacroNode statement) {
        this.statement = statement;
    }

    @Override
    public void visit(Consumer<AbstractMacroNode> consumer) {
        consumer.accept(this);
        if (this.statement != null) {
            this.statement.visit(consumer);
        }
    }

    @Override
    public String toString() {
        return this.trigger;
    }

    @Override
    public VariableStorage getVariableStorage() {
        return this.variableStorage;
    }

    public void activate() {
        if (this.activated) {
            LOGGER.debug(this + " was still active, resetting");
            this.deactivate();
        }
        if (this.needsCleanup) {
            this.variableStorage.clear();
            this.statement = this.statement.copy(this);
            this.needsCleanup = false;
            this.waitFrames = 0;
        }
        LOGGER.debug(this + " got activated");
        this.activated = true;
    }

    public void deactivate() {
        this.activated = false;
        this.needsCleanup = true;
    }

    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public MacroMacroNode getRoot() {
        return this;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public Set<Attribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    @Override
    public AbstractMacroNode copy(AbstractMacroNode newParent) {
        throw new UnsupportedOperationException("Can't copy top level macro " + this.trigger);
    }

    public boolean isEcho() {
        return this.getVariableStorage().get("@env.echo").asString().equals("true");
    }

    public boolean isDebug() {
        return this.getVariableStorage().get("@env.debug").asString().equals("true");
    }

    public boolean isKeyInterrupts() {
        return this.getVariableStorage().get("@env.key_interrupts").asString().equals("true");
    }

    public boolean isClickInterrupts() {
        return this.getVariableStorage().get("@env.click_interrupts").asString().equals("true");
    }

    public static enum Attribute {
        IGNORE_CASE,
        ANY_CLICK,
        NO_OVERRIDE;

    }
}

