/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.node;

import java.util.function.Consumer;
import net.heberling.clanlord.macro.interpreter.node.AbstractMacroNode;
import net.heberling.clanlord.macro.interpreter.variable.Variable;
import net.heberling.clanlord.macro.parser.MacroParser;

public class IfMacroNode
extends AbstractMacroNode {
    private final MacroParser.ConditionContext condition;
    private AbstractMacroNode ifThen;
    private AbstractMacroNode ifElse;
    private Boolean satisfied;

    public IfMacroNode(MacroParser.ConditionContext condition) {
        this.condition = condition;
    }

    public void setIfThen(AbstractMacroNode ifThen) {
        this.ifThen = ifThen;
    }

    public void setIfElse(AbstractMacroNode ifElse) {
        this.ifElse = ifElse;
    }

    @Override
    public AbstractMacroNode.Result tick() {
        AbstractMacroNode node;
        if (this.satisfied == null) {
            this.satisfied = this.checkCondition();
        }
        AbstractMacroNode abstractMacroNode = node = this.satisfied != false ? this.ifThen : this.ifElse;
        if (node != null) {
            return node.tick();
        }
        return new AbstractMacroNode.Result(true, 0, null, null);
    }

    public boolean checkCondition() {
        Variable leftValue = this.getValue(this.condition.left);
        Variable rightValue = this.getValue(this.condition.right);
        if (leftValue.isNumeric() && rightValue.isNumeric()) {
            switch (this.condition.COMPARATOR().getText()) {
                case "==": {
                    return leftValue.asNumber() == rightValue.asNumber();
                }
                case "!=": {
                    return leftValue.asNumber() != rightValue.asNumber();
                }
                case "<=": {
                    return leftValue.asNumber() <= rightValue.asNumber();
                }
                case "<": {
                    return leftValue.asNumber() < rightValue.asNumber();
                }
                case ">=": {
                    return leftValue.asNumber() >= rightValue.asNumber();
                }
                case ">": {
                    return leftValue.asNumber() > rightValue.asNumber();
                }
            }
            throw new IllegalArgumentException("Invalid comparator: " + this.condition.COMPARATOR().getText());
        }
        switch (this.condition.COMPARATOR().getText()) {
            case "==": {
                return leftValue.asString().equals(rightValue.asString());
            }
            case "!=": {
                return !leftValue.asString().equals(rightValue.asString());
            }
            case "<=": 
            case "<": {
                return leftValue.asString().contains(rightValue.asString());
            }
            case ">=": 
            case ">": {
                return rightValue.asString().contains(leftValue.asString());
            }
        }
        throw new IllegalArgumentException("Invalid comparator: " + this.condition.COMPARATOR().getText());
    }

    @Override
    public void visit(Consumer<AbstractMacroNode> consumer) {
        consumer.accept(this);
        this.ifThen.visit(consumer);
        if (this.ifElse != null) {
            this.ifElse.visit(consumer);
        }
    }

    @Override
    public String toString() {
        return "if " + this.condition.getText();
    }

    @Override
    public AbstractMacroNode copy(AbstractMacroNode newParent) {
        IfMacroNode ifMacroNode = new IfMacroNode(this.condition);
        ifMacroNode.setParent(newParent);
        ifMacroNode.setIfThen(this.ifThen.copy(ifMacroNode));
        if (this.ifElse != null) {
            ifMacroNode.setIfElse(this.ifElse.copy(ifMacroNode));
        }
        return ifMacroNode;
    }
}

