/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.node;

import net.heberling.clanlord.macro.interpreter.MacroCompiler;
import net.heberling.clanlord.macro.interpreter.node.AbstractMacroNode;
import net.heberling.clanlord.macro.interpreter.node.AbstractTerminalMacroNode;
import net.heberling.clanlord.macro.interpreter.node.MacroMacroNode;

public class CallMacroNode
extends AbstractTerminalMacroNode {
    private final MacroCompiler macroCompiler;
    private final String calledMacro;
    private AbstractMacroNode macroNode;

    public CallMacroNode(MacroCompiler macroCompiler, String calledMacro) {
        this.macroCompiler = macroCompiler;
        this.calledMacro = calledMacro;
    }

    @Override
    public AbstractMacroNode.Result tick() {
        AbstractMacroNode.Result result;
        if (this.macroNode == null) {
            MacroMacroNode macroMacroNode = this.macroCompiler.getMacro(this.calledMacro);
            if (macroMacroNode == null) {
                throw new IllegalStateException("Could not find macro " + this.calledMacro);
            }
            macroMacroNode.getAttributes().forEach(this.getRoot()::addAttribute);
            this.macroNode = macroMacroNode.getStatement().copy(this);
        }
        if ((result = this.macroNode.tick()).isFinished()) {
            this.macroNode = null;
        }
        return result;
    }

    @Override
    public String toString() {
        return "call " + this.calledMacro;
    }

    @Override
    public AbstractMacroNode copy(AbstractMacroNode newParent) {
        CallMacroNode callMacroNode = new CallMacroNode(this.macroCompiler, this.calledMacro);
        callMacroNode.setParent(newParent);
        return callMacroNode;
    }
}

