/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter.node;

import java.util.function.Consumer;
import net.heberling.clanlord.macro.interpreter.node.MacroMacroNode;
import net.heberling.clanlord.macro.interpreter.variable.LiteralVariable;
import net.heberling.clanlord.macro.interpreter.variable.Variable;
import net.heberling.clanlord.macro.interpreter.variable.VariableStorage;
import net.heberling.clanlord.macro.parser.MacroParser;

public abstract class AbstractMacroNode {
    private AbstractMacroNode parent;

    public void setParent(AbstractMacroNode parent) {
        this.parent = parent;
    }

    public AbstractMacroNode getParent() {
        return this.parent;
    }

    public abstract Result tick();

    public abstract void visit(Consumer<AbstractMacroNode> var1);

    public VariableStorage getVariableStorage() {
        return this.getRoot().getVariableStorage();
    }

    public MacroMacroNode getRoot() {
        return this.getParent().getRoot();
    }

    public abstract AbstractMacroNode copy(AbstractMacroNode var1);

    public abstract String toString();

    protected Variable getValue(MacroParser.ValueContext ctx) {
        if (ctx.NUMBER() != null) {
            int number = Integer.parseInt(ctx.NUMBER().getText());
            if (ctx.MINUS() != null) {
                number = -number;
            }
            return new LiteralVariable(number);
        }
        if (ctx.QUOTED() != null) {
            return new LiteralVariable(ctx.QUOTED().getText().substring(1, ctx.QUOTED().getText().length() - 1).replace("\\\"", "\""));
        }
        return this.getVariableStorage().get(ctx.IDENTIFIER().getText());
    }

    public static final class Result {
        final boolean finished;
        final int waitFrames;
        final String text;
        final String label;

        public Result(boolean finished, int waitFrames, String text, String label) {
            this.finished = finished;
            this.waitFrames = waitFrames;
            this.text = text;
            this.label = label;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public int getWaitFrames() {
            return this.waitFrames;
        }

        public String getText() {
            return this.text;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

