/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.macro.interpreter;

import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.heberling.clanlord.macro.interpreter.BailErrorListener;
import net.heberling.clanlord.macro.interpreter.MacroCallback;
import net.heberling.clanlord.macro.interpreter.node.AbstractMacroNode;
import net.heberling.clanlord.macro.interpreter.node.CallMacroNode;
import net.heberling.clanlord.macro.interpreter.node.GotoMacroNode;
import net.heberling.clanlord.macro.interpreter.node.IfMacroNode;
import net.heberling.clanlord.macro.interpreter.node.LabelMacroNode;
import net.heberling.clanlord.macro.interpreter.node.MacroMacroNode;
import net.heberling.clanlord.macro.interpreter.node.MessageStatementMacroNode;
import net.heberling.clanlord.macro.interpreter.node.PauseMacroNode;
import net.heberling.clanlord.macro.interpreter.node.RandomStatementMacroNode;
import net.heberling.clanlord.macro.interpreter.node.SequenceMacroNode;
import net.heberling.clanlord.macro.interpreter.node.SetMacroNode;
import net.heberling.clanlord.macro.interpreter.node.TextCommandStatementMacroNode;
import net.heberling.clanlord.macro.parser.MacroBaseListener;
import net.heberling.clanlord.macro.parser.MacroLexer;
import net.heberling.clanlord.macro.parser.MacroParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroCompiler
extends MacroBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroCompiler.class);
    private final ParseTreeProperty<AbstractMacroNode> treeMap = new ParseTreeProperty();
    private final HashMap<String, MacroMacroNode> macroMap = new HashMap();
    private final MacroCallback callback;

    public MacroCompiler(MacroCallback callback) {
        this.callback = callback;
    }

    public void enterInclude_macro(MacroParser.Include_macroContext ctx) {
        try {
            MacroLexer macroLexer = new MacroLexer(CharStreams.fromStream((InputStream)new SequenceInputStream(new FileInputStream(this.callback.getMacroFile(ctx.QUOTED().getText().substring(1, ctx.QUOTED().getText().length() - 1))), new ByteArrayInputStream(new byte[]{10}))));
            macroLexer.addErrorListener((ANTLRErrorListener)new BailErrorListener());
            MacroParser macroParser = new MacroParser((TokenStream)new CommonTokenStream((TokenSource)macroLexer));
            macroParser.addErrorListener((ANTLRErrorListener)new BailErrorListener());
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)this, (ParseTree)macroParser.macros());
        }
        catch (IOException e) {
            throw new BailErrorListener.BailException(e.getMessage(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStart().getStartIndex());
        }
    }

    public void enterSet_macro(MacroParser.Set_macroContext ctx) {
        SetMacroNode setMacroNode = new SetMacroNode(ctx.IDENTIFIER().getText(), true, ctx.set_expression());
        setMacroNode.setParent(new MacroMacroNode("dummy"));
        setMacroNode.tick();
    }

    public void enterIdentifier_macro(MacroParser.Identifier_macroContext ctx) {
        MacroMacroNode macroMacroNode = new MacroMacroNode(ctx.IDENTIFIER().getText().trim());
        this.addTreeNode((RuleContext)ctx, macroMacroNode);
        LOGGER.debug("Registering macro trigger: " + ctx.IDENTIFIER().getText());
        this.macroMap.put(ctx.IDENTIFIER().getText(), macroMacroNode);
    }

    public void exitIdentifier_macro(MacroParser.Identifier_macroContext ctx) {
        MacroMacroNode macroMacroNode = (MacroMacroNode)this.getMacroNode((RuleContext)ctx);
        macroMacroNode.setStatement(this.getMacroNode((RuleContext)ctx.statement()));
    }

    public void enterExpression_macro(MacroParser.Expression_macroContext ctx) {
        MacroMacroNode macroMacroNode = new MacroMacroNode(ctx.trigger.getText().trim());
        this.addTreeNode((RuleContext)ctx, macroMacroNode);
    }

    public void exitExpression_macro(MacroParser.Expression_macroContext ctx) {
        MacroMacroNode macroMacroNode = (MacroMacroNode)this.getMacroNode((RuleContext)ctx);
        macroMacroNode.setStatement(this.getMacroNode((RuleContext)ctx.statement()));
        String trigger = ctx.trigger.getText();
        if (macroMacroNode.getAttributes().contains((Object)MacroMacroNode.Attribute.IGNORE_CASE)) {
            trigger = trigger.toLowerCase();
        }
        LOGGER.debug("Registering macro trigger: " + trigger);
        this.macroMap.put(trigger, macroMacroNode);
    }

    public void enterReplacement_macro(MacroParser.Replacement_macroContext ctx) {
        MacroMacroNode macroMacroNode = new MacroMacroNode(ctx.SINGLE_QUOTED().getText().trim());
        this.addTreeNode((RuleContext)ctx, macroMacroNode);
    }

    public void exitReplacement_macro(MacroParser.Replacement_macroContext ctx) {
        MacroMacroNode macroMacroNode = (MacroMacroNode)this.getMacroNode((RuleContext)ctx);
        macroMacroNode.setStatement(this.getMacroNode((RuleContext)ctx.statement()));
        String trigger = ctx.SINGLE_QUOTED().getText();
        if (macroMacroNode.getAttributes().contains((Object)MacroMacroNode.Attribute.IGNORE_CASE)) {
            trigger = trigger.toLowerCase();
        }
        LOGGER.debug("Registering macro trigger: " + trigger);
        this.macroMap.put(trigger, macroMacroNode);
    }

    public void enterKey_macro(MacroParser.Key_macroContext ctx) {
        int keycode = MacroCompiler.getKeyCodeFromString(ctx.key.getText());
        int modifiers = MacroCompiler.getModifiersFromString(ctx.modifier.stream().map(Token::getText).collect(Collectors.joining("-")));
        String macroTrigger = modifiers + "-" + keycode;
        MacroMacroNode macroMacroNode = new MacroMacroNode(macroTrigger);
        this.addTreeNode((RuleContext)ctx, macroMacroNode);
        LOGGER.debug("Registering macro trigger: " + macroTrigger);
        this.macroMap.put(macroTrigger, macroMacroNode);
    }

    public void exitKey_macro(MacroParser.Key_macroContext ctx) {
        MacroMacroNode macroMacroNode = (MacroMacroNode)this.getMacroNode((RuleContext)ctx);
        macroMacroNode.setStatement(this.getMacroNode((RuleContext)ctx.statement()));
    }

    public static int getKeyCodeFromString(String s) {
        boolean numpad = s.contains("numpad");
        if (s.contains("-")) {
            s = s.substring(s.lastIndexOf("-") + 1);
        }
        if ((s = s.trim().toLowerCase()).equals("f1")) {
            return 112;
        }
        if (s.equals("f2")) {
            return 113;
        }
        if (s.equals("f3")) {
            return 114;
        }
        if (s.equals("f4")) {
            return 115;
        }
        if (s.equals("f5")) {
            return 116;
        }
        if (s.equals("f6")) {
            return 117;
        }
        if (s.equals("f7")) {
            return 118;
        }
        if (s.equals("f8")) {
            return 119;
        }
        if (s.equals("f9")) {
            return 120;
        }
        if (s.equals("f10")) {
            return 121;
        }
        if (s.equals("f11")) {
            return 122;
        }
        if (s.equals("f12")) {
            return 123;
        }
        if (s.equals("f13")) {
            return 61440;
        }
        if (s.equals("f14")) {
            return 61441;
        }
        if (s.equals("f15")) {
            return 61442;
        }
        if (s.equals("escape")) {
            return 27;
        }
        if (s.equals("minus")) {
            return 45;
        }
        if (s.equals("delete")) {
            return 127;
        }
        if (s.equals("tab")) {
            return 9;
        }
        if (s.equals("return")) {
            return 10;
        }
        if (s.equals("space")) {
            return 32;
        }
        if (s.equals("help")) {
            return 156;
        }
        if (s.equals("home")) {
            return 36;
        }
        if (s.equals("undo")) {
            return 65483;
        }
        if (s.equals("del")) {
            return 127;
        }
        if (s.equals("end")) {
            return 35;
        }
        if (s.equals("pageup")) {
            return 33;
        }
        if (s.equals("pagedown")) {
            return 34;
        }
        if (s.equals("up")) {
            return 38;
        }
        if (s.equals("down")) {
            return 40;
        }
        if (s.equals("left")) {
            return 37;
        }
        if (s.equals("right")) {
            return 39;
        }
        if (s.equals("clear")) {
            return 12;
        }
        if (s.equals("enter")) {
            return 10;
        }
        if (s.equals("click1") || s.equals("click")) {
            return -1;
        }
        if (s.equals("click2")) {
            return -2;
        }
        if (s.equals("click3")) {
            return -3;
        }
        if (s.length() == 1) {
            if (numpad) {
                return 96 + Integer.parseInt(s);
            }
            return KeyEvent.getExtendedKeyCodeForChar(s.charAt(0));
        }
        return 0;
    }

    public static int getModifiersFromString(String s) {
        int modifiers = 0;
        s = "-" + s.toLowerCase().trim() + "-";
        if (s.contains("-command-")) {
            modifiers |= 0x100;
        }
        if (s.contains("-control-")) {
            modifiers |= 0x80;
        }
        if (s.contains("-option-")) {
            modifiers |= 0x200;
        }
        if (s.contains("-shift-")) {
            modifiers |= 0x40;
        }
        return modifiers;
    }

    public void enterAlt_setglobal(MacroParser.Alt_setglobalContext ctx) {
        this.addTreeNode((RuleContext)ctx, new SetMacroNode(ctx.IDENTIFIER().getText().trim(), true, ctx.set_expression()));
    }

    public void enterAlt_set(MacroParser.Alt_setContext ctx) {
        this.addTreeNode((RuleContext)ctx, new SetMacroNode(ctx.IDENTIFIER().getText().trim(), false, ctx.set_expression()));
    }

    public void enterStatements(MacroParser.StatementsContext ctx) {
        SequenceMacroNode sequenceMacroNode = new SequenceMacroNode("seq");
        this.addTreeNode((RuleContext)ctx, sequenceMacroNode);
    }

    public void exitStatements(MacroParser.StatementsContext ctx) {
        SequenceMacroNode sequenceMacroNode = (SequenceMacroNode)this.getMacroNode((RuleContext)ctx);
        ctx.statement().forEach(s -> sequenceMacroNode.addChildMacroNode(this.getMacroNode((RuleContext)s)));
    }

    public void enterStatement_block(MacroParser.Statement_blockContext ctx) {
        SequenceMacroNode sequenceMacroNode = new SequenceMacroNode("seq");
        this.addTreeNode((RuleContext)ctx, sequenceMacroNode);
    }

    public void exitStatement_block(MacroParser.Statement_blockContext ctx) {
        SequenceMacroNode sequenceMacroNode = (SequenceMacroNode)this.getMacroNode((RuleContext)ctx);
        sequenceMacroNode.addChildMacroNode(this.getMacroNode((RuleContext)ctx.statements()));
    }

    public void enterAlt_statement_block(MacroParser.Alt_statement_blockContext ctx) {
        SequenceMacroNode sequenceMacroNode = new SequenceMacroNode("seq");
        this.addTreeNode((RuleContext)ctx, sequenceMacroNode);
    }

    public void exitAlt_statement_block(MacroParser.Alt_statement_blockContext ctx) {
        SequenceMacroNode sequenceMacroNode = (SequenceMacroNode)this.getMacroNode((RuleContext)ctx);
        sequenceMacroNode.addChildMacroNode(this.getMacroNode((RuleContext)ctx.statement_block()));
    }

    public void enterAlt_label(MacroParser.Alt_labelContext ctx) {
        this.addTreeNode((RuleContext)ctx, new LabelMacroNode(ctx.IDENTIFIER().getText().trim()));
    }

    public void enterAlt_goto(MacroParser.Alt_gotoContext ctx) {
        this.addTreeNode((RuleContext)ctx, new GotoMacroNode(ctx.IDENTIFIER().getText().trim()));
    }

    public void enterAlt_call(MacroParser.Alt_callContext ctx) {
        this.addTreeNode((RuleContext)ctx, new CallMacroNode(this, ctx.IDENTIFIER().getText().trim()));
    }

    public void enterAlt_if(MacroParser.Alt_ifContext ctx) {
        this.addTreeNode((RuleContext)ctx, new IfMacroNode(ctx.condition()));
    }

    public void enterAlt_elseif(MacroParser.Alt_elseifContext ctx) {
        IfMacroNode macroNode = new IfMacroNode(ctx.condition());
        this.addTreeNode((RuleContext)ctx, macroNode);
        ((IfMacroNode)this.getParentMacroNode((RuleContext)ctx)).setIfElse(macroNode);
    }

    public void enterAlt_else(MacroParser.Alt_elseContext ctx) {
        SequenceMacroNode macroNode = new SequenceMacroNode("else");
        this.addTreeNode((RuleContext)ctx, macroNode);
        ((IfMacroNode)this.getParentMacroNode((RuleContext)ctx)).setIfElse(macroNode);
    }

    public void enterThen_statements(MacroParser.Then_statementsContext ctx) {
        SequenceMacroNode macroNode = new SequenceMacroNode("then");
        this.addTreeNode((RuleContext)ctx, macroNode);
        ((IfMacroNode)this.getParentMacroNode((RuleContext)ctx)).setIfThen(macroNode);
    }

    public void exitThen_statements(MacroParser.Then_statementsContext ctx) {
        SequenceMacroNode sequenceMacroNode = (SequenceMacroNode)this.getMacroNode((RuleContext)ctx);
        if (ctx.statements() != null) {
            sequenceMacroNode.addChildMacroNode(this.getMacroNode((RuleContext)ctx.statements()));
        }
    }

    public void exitElse_statements(MacroParser.Else_statementsContext ctx) {
        SequenceMacroNode sequenceMacroNode = (SequenceMacroNode)this.getParentMacroNode((RuleContext)ctx);
        if (ctx.statements() != null) {
            sequenceMacroNode.addChildMacroNode(this.getMacroNode((RuleContext)ctx.statements()));
        }
    }

    public void enterAlt_random(MacroParser.Alt_randomContext ctx) {
        this.addTreeNode((RuleContext)ctx, new RandomStatementMacroNode(ctx.NOREPEAT() != null));
    }

    public void exitAlt_random(MacroParser.Alt_randomContext ctx) {
        RandomStatementMacroNode sequenceMacroNode = (RandomStatementMacroNode)this.getMacroNode((RuleContext)ctx);
        if (ctx.statements() != null) {
            ctx.statements().stream().map(this::getMacroNode).forEach(sequenceMacroNode::addChildMacroNode);
        }
    }

    public void enterAlt_message(MacroParser.Alt_messageContext ctx) {
        this.addTreeNode((RuleContext)ctx, new MessageStatementMacroNode(ctx.value(), this.callback));
    }

    public void enterAlt_text_command(MacroParser.Alt_text_commandContext ctx) {
        this.addTreeNode((RuleContext)ctx, new TextCommandStatementMacroNode(ctx.text_command().value()));
    }

    public void enterAlt_pause_command(MacroParser.Alt_pause_commandContext ctx) {
        this.addTreeNode((RuleContext)ctx, new PauseMacroNode(ctx.value()));
    }

    public void enterAlt_attribute(MacroParser.Alt_attributeContext ctx) {
        switch (ctx.ATTRIBUTE().getText()) {
            case "$ignore_case": {
                this.getParentMacroNode((RuleContext)ctx).getRoot().addAttribute(MacroMacroNode.Attribute.IGNORE_CASE);
                break;
            }
            case "$any_click": {
                this.getParentMacroNode((RuleContext)ctx).getRoot().addAttribute(MacroMacroNode.Attribute.ANY_CLICK);
                break;
            }
            case "$no_override": {
                this.getParentMacroNode((RuleContext)ctx).getRoot().addAttribute(MacroMacroNode.Attribute.NO_OVERRIDE);
                break;
            }
            default: {
                throw new BailErrorListener.BailException("Invalid attribute " + ctx.getText(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStart().getStartIndex());
            }
        }
    }

    private void addTreeNode(RuleContext node, AbstractMacroNode macroNode) {
        AbstractMacroNode parentTreeNode = this.getParentMacroNode(node);
        macroNode.setParent(parentTreeNode);
        this.treeMap.put((ParseTree)node, (Object)macroNode);
    }

    private AbstractMacroNode getParentMacroNode(RuleContext node) {
        if (node == null) {
            return null;
        }
        AbstractMacroNode treeNode = (AbstractMacroNode)this.treeMap.get((ParseTree)node.parent);
        if (treeNode == null) {
            treeNode = this.getParentMacroNode(node.parent);
        }
        return treeNode;
    }

    private AbstractMacroNode getMacroNode(RuleContext node) {
        if (node == null) {
            return null;
        }
        return (AbstractMacroNode)this.treeMap.get((ParseTree)node);
    }

    public MacroMacroNode getMacro(String trigger) {
        return this.macroMap.get(trigger.trim());
    }

    public Collection<MacroMacroNode> getMacros() {
        return this.macroMap.values();
    }

    public static MacroCompiler parseMacroFile(File f, MacroCallback callback) {
        MacroCompiler storage = null;
        try {
            MacroLexer macroLexer = new MacroLexer(CharStreams.fromStream((InputStream)new SequenceInputStream(new FileInputStream(f), new ByteArrayInputStream(new byte[]{10}))));
            macroLexer.addErrorListener((ANTLRErrorListener)new BailErrorListener());
            MacroParser macroParser = new MacroParser((TokenStream)new CommonTokenStream((TokenSource)macroLexer));
            macroParser.addErrorListener((ANTLRErrorListener)new BailErrorListener());
            storage = new MacroCompiler(callback);
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)storage, (ParseTree)macroParser.macros());
        }
        catch (IOException e) {
            LOGGER.debug("Failed parsing of macro file {}", (Object)f, (Object)e);
            callback.addSystemMessage("\u2022failed parsing of macro file \"" + f + "\": " + e.getLocalizedMessage());
        }
        catch (BailErrorListener.BailException e) {
            LOGGER.debug("Failed parsing of macro file {}", (Object)f, (Object)e);
            callback.addSystemMessage("\u2022failed parsing of macro file \"" + f + "(" + e.getLine() + ":" + e.getCharPositionInLine() + ")\": " + e.getLocalizedMessage());
        }
        return storage;
    }
}

