/*
 * Decompiled with CFR 0.152.
 */
package net.heartsavior.spark.sql.state;

import java.util.UUID;
import net.heartsavior.spark.sql.state.StateStoreWriter$;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.hack.SerializableConfiguration;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u0011\u0001c\u0015;bi\u0016\u001cFo\u001c:f/JLG/\u001a:\u000b\u0005\r!\u0011!B:uCR,'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u0017!,\u0017M\u001d;tCZLwN\u001d\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!\u0011!Q\u0001\nY\tqa]3tg&|g\u000e\u0005\u0002\u0018=5\t\u0001D\u0003\u0002\u00063)\u0011qA\u0007\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014x-\u0003\u0002 1\ta1\u000b]1sWN+7o]5p]\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0003eCR\f\u0007CA\u00122\u001d\t!sF\u0004\u0002&]9\u0011a%\f\b\u0003O1r!\u0001K\u0016\u000e\u0003%R!A\u000b\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012BA\u000e\u001d\u0013\t9!$\u0003\u0002\u00063%\u0011\u0001\u0007G\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114GA\u0005ECR\fgI]1nK*\u0011\u0001\u0007\u0007\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005I1.Z=TG\",W.\u0019\t\u0003oij\u0011\u0001\u000f\u0006\u0003sa\tQ\u0001^=qKNL!a\u000f\u001d\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005>\u0001\t\u0005\t\u0015!\u00037\u0003-1\u0018\r\\;f'\u000eDW-\\1\t\u0011}\u0002!\u0011!Q\u0001\n\u0001\u000bqc\u001d;bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\u0011\u0005\u0005#eBA\bC\u0013\t\u0019\u0005#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"\u0011\u0011!A\u0005A!A!\u0002\u0013I\u0015a\u0002<feNLwN\u001c\t\u0003\u001f)K!a\u0013\t\u0003\u0007%sG\u000f\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003J\u0003)y\u0007/\u001a:bi>\u0014\u0018\n\u001a\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0001\u0006I1\u000f^8sK:\u000bW.\u001a\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0013\u0006ia.Z<QCJ$\u0018\u000e^5p]NDQa\u0015\u0001\u0005\u0002Q\u000ba\u0001P5oSRtDCC+X1fS6\fX/_?B\u0011a\u000bA\u0007\u0002\u0005!)QC\u0015a\u0001-!)\u0011E\u0015a\u0001E!)QG\u0015a\u0001m!)QH\u0015a\u0001m!)qH\u0015a\u0001\u0001\")\u0001J\u0015a\u0001\u0013\")QJ\u0015a\u0001\u0013\")qJ\u0015a\u0001\u0001\")\u0011K\u0015a\u0001\u0013\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0017!C:u_J,7i\u001c8g+\u0005\u0019\u0007C\u00013k\u001b\u0005)'BA\u0002g\u0015\t9\u0007.A\u0005tiJ,\u0017-\\5oO*\u0011\u0011\u000eG\u0001\nKb,7-\u001e;j_:L!a[3\u0003\u001dM#\u0018\r^3Ti>\u0014XmQ8oM\"1Q\u000e\u0001Q\u0001\n\r\f!b\u001d;pe\u0016\u001cuN\u001c4!\u0011\u001dy\u0007A1A\u0005\nA\f1\u0003[1e_>\u00048i\u001c8g\u0005J|\u0017\rZ2bgR,\u0012!\u001d\t\u0004eV<X\"A:\u000b\u0005QL\u0012!\u00032s_\u0006$7-Y:u\u0013\t18OA\u0005Ce>\fGmY1tiB\u0011\u0001p_\u0007\u0002s*\u0011!\u0010G\u0001\u0005Q\u0006\u001c7.\u0003\u0002}s\nI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0011\u0019q\b\u0001)A\u0005c\u0006!\u0002.\u00193p_B\u001cuN\u001c4Ce>\fGmY1ti\u0002Bq!!\u0001\u0001\t\u0003\t\u0019!A\u0003xe&$X\r\u0006\u0002\u0002\u0006A\u0019q\"a\u0002\n\u0007\u0005%\u0001C\u0001\u0003V]&$xaBA\u0007\u0005!\u0005\u0011qB\u0001\u0011'R\fG/Z*u_J,wK]5uKJ\u00042AVA\t\r\u0019\t!\u0001#\u0001\u0002\u0014M\u0019\u0011\u0011\u0003\b\t\u000fM\u000b\t\u0002\"\u0001\u0002\u0018Q\u0011\u0011q\u0002\u0005\t\u00037\t\t\u0002\"\u0001\u0002\u001e\u00059qO]5uK\u001asG\u0003FA\u0010\u0003\u0003\n)%a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019\u0006E\u0004\u0010\u0003C\t)#!\u0002\n\u0007\u0005\r\u0002CA\u0005Gk:\u001cG/[8ocA1\u0011qEA\u0018\u0003kqA!!\u000b\u0002.9\u0019\u0001&a\u000b\n\u0003EI!\u0001\r\t\n\t\u0005E\u00121\u0007\u0002\t\u0013R,'/\u0019;pe*\u0011\u0001\u0007\u0005\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\r\u0002\u0011\r\fG/\u00197zgRLA!a\u0010\u0002:\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\t\u0019%!\u0007A\u0002\u0001\u000b!C]3t_24X\rZ\"q\u0019>\u001c\u0017\r^5p]\"1\u0001*!\u0007A\u0002%Ca!TA\r\u0001\u0004I\u0005BB(\u0002\u001a\u0001\u0007\u0001\t\u0003\u00046\u00033\u0001\rA\u000e\u0005\u0007{\u0005e\u0001\u0019\u0001\u001c\t\r\u0005\fI\u00021\u0001d\u0011\u0019y\u0017\u0011\u0004a\u0001c\"A\u0011QKA\r\u0001\u0004\t9&A\u0004rk\u0016\u0014\u00180\u00133\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!Q\u000f^5m\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u00037\u0012A!V+J\t\u0002")
public class StateStoreWriter {
    private final SparkSession session;
    private final Dataset<Row> data;
    private final StructType keySchema;
    private final StructType valueSchema;
    private final String stateCheckpointLocation;
    private final int version;
    private final int operatorId;
    private final String storeName;
    private final int newPartitions;
    private final StateStoreConf storeConf;
    private final Broadcast<SerializableConfiguration> hadoopConfBroadcast;

    public static Function1<Iterator<InternalRow>, BoxedUnit> writeFn(String string, int n, int n2, String string2, StructType structType, StructType structType2, StateStoreConf stateStoreConf, Broadcast<SerializableConfiguration> broadcast, UUID uUID) {
        return StateStoreWriter$.MODULE$.writeFn(string, n, n2, string2, structType, structType2, stateStoreConf, broadcast, uUID);
    }

    private StateStoreConf storeConf() {
        return this.storeConf;
    }

    private Broadcast<SerializableConfiguration> hadoopConfBroadcast() {
        return this.hadoopConfBroadcast;
    }

    public void write() {
        Path checkpointPath = new Path(this.stateCheckpointLocation);
        FileSystem fs = checkpointPath.getFileSystem(this.session.sessionState().newHadoopConf());
        if (fs.exists(checkpointPath)) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint location should not be exist. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkpointPath}))).toString());
        }
        fs.mkdirs(checkpointPath);
        String resolvedCpLocation = checkpointPath.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toUri().toString();
        UUID queryId = UUID.randomUUID();
        Seq fullPathsForKeyColumns = (Seq)this.keySchema.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Column apply(StructField key) {
                return new Column(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.name()})));
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.data.repartition(this.newPartitions, fullPathsForKeyColumns).queryExecution().toRdd().foreachPartition(StateStoreWriter$.MODULE$.writeFn(resolvedCpLocation, this.version, this.operatorId, this.storeName, this.keySchema, this.valueSchema, this.storeConf(), this.hadoopConfBroadcast(), queryId));
    }

    public StateStoreWriter(SparkSession session, Dataset<Row> data, StructType keySchema, StructType valueSchema, String stateCheckpointLocation, int version, int operatorId, String storeName, int newPartitions) {
        this.session = session;
        this.data = data;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.stateCheckpointLocation = stateCheckpointLocation;
        this.version = version;
        this.operatorId = operatorId;
        this.storeName = storeName;
        this.newPartitions = newPartitions;
        this.storeConf = new StateStoreConf(session.sessionState().conf());
        this.hadoopConfBroadcast = session.sparkContext().broadcast((Object)new SerializableConfiguration(session.sessionState().newHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
    }
}

