/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.hasor.core.Hasor;
import net.hasor.db.jdbc.SqlParameterSource;

public class ParsedSql {
    private String originalSql;
    private int namedParameterCount;
    private int unnamedParameterCount;
    private int totalParameterCount;
    private List<String> parameterNames;
    private List<int[]> parameterIndexes;
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    private ParsedSql(String originalSql) {
        this.originalSql = originalSql;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public int getNamedParameterCount() {
        return this.namedParameterCount;
    }

    public int getUnnamedParameterCount() {
        return this.unnamedParameterCount;
    }

    public int getTotalParameterCount() {
        return this.totalParameterCount;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public List<int[]> getParameterIndexes() {
        return this.parameterIndexes;
    }

    public static ParsedSql getParsedSql(String originalSql) {
        ParsedSql parSQL = new ParsedSql(originalSql);
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<int[]> parameterIndexes = new ArrayList<int[]>();
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        Hasor.assertIsNotNull((Object)originalSql, (String)"SQL must not be null");
        HashSet<String> namedParameters = new HashSet<String>();
        char[] statement = originalSql.toCharArray();
        int i = 0;
        while (i < statement.length) {
            char c;
            int skipToPosition = ParsedSql.skipCommentsAndQuotes(statement, i);
            if (i != skipToPosition) {
                if (skipToPosition >= statement.length) break;
                i = skipToPosition;
            }
            if ((c = statement[i]) == ':' || c == '&') {
                int j = i + 1;
                if (j < statement.length && statement[j] == ':' && c == ':') {
                    i += 2;
                    continue;
                }
                while (j < statement.length && !ParsedSql.isParameterSeparator(statement[j])) {
                    ++j;
                }
                if (j - i > 1) {
                    String parameter = originalSql.substring(i + 1, j);
                    if (!namedParameters.contains(parameter)) {
                        namedParameters.add(parameter);
                        ++namedParameterCount;
                    }
                    parameterNames.add(parameter);
                    parameterIndexes.add(new int[]{i, j});
                    ++totalParameterCount;
                }
                i = j - 1;
            } else if (c == '?') {
                ++unnamedParameterCount;
                ++totalParameterCount;
            }
            ++i;
        }
        parSQL.namedParameterCount = namedParameterCount;
        parSQL.unnamedParameterCount = unnamedParameterCount;
        parSQL.totalParameterCount = totalParameterCount;
        parSQL.parameterIndexes = parameterIndexes;
        parSQL.parameterNames = parameterNames;
        return parSQL;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char separator : PARAMETER_SEPARATORS) {
            if (c != separator) continue;
            return true;
        }
        return false;
    }

    public static String buildSql(ParsedSql parsedSql, SqlParameterSource paramSource) {
        String originalSql = parsedSql.getOriginalSql();
        List<String> parameterNames = parsedSql.getParameterNames();
        List<int[]> parameterIndexes = parsedSql.getParameterIndexes();
        StringBuilder sqlToUse = new StringBuilder();
        int lastIndex = 0;
        for (int i = 0; i < parameterNames.size(); ++i) {
            String paramName = parameterNames.get(i);
            int[] indexes = parameterIndexes.get(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            sqlToUse.append(originalSql.substring(lastIndex, startIndex));
            if (paramSource != null && paramSource.hasValue(paramName)) {
                Object value = paramSource.getValue(paramName);
                if (value instanceof Collection) {
                    Iterator entryIter = ((Collection)value).iterator();
                    int k = 0;
                    while (entryIter.hasNext()) {
                        if (k > 0) {
                            sqlToUse.append(", ");
                        }
                        ++k;
                        Object entryItem = entryIter.next();
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            sqlToUse.append("(");
                            for (int m = 0; m < expressionList.length; ++m) {
                                if (m > 0) {
                                    sqlToUse.append(", ");
                                }
                                sqlToUse.append("?");
                            }
                            sqlToUse.append(")");
                            continue;
                        }
                        sqlToUse.append("?");
                    }
                } else {
                    sqlToUse.append("?");
                }
            } else {
                sqlToUse.append("?");
            }
            lastIndex = endIndex;
        }
        sqlToUse.append(originalSql.substring(lastIndex, originalSql.length()));
        return sqlToUse.toString();
    }

    public static Object[] buildSqlValues(ParsedSql parsedSql, SqlParameterSource paramSource) throws SQLException {
        String originalSql = parsedSql.getOriginalSql();
        List<String> parameterNames = parsedSql.getParameterNames();
        int namedParameterCount = parsedSql.getNamedParameterCount();
        int unnamedParameterCount = parsedSql.getUnnamedParameterCount();
        int totalParameterCount = parsedSql.getTotalParameterCount();
        Object[] paramArray = new Object[totalParameterCount];
        if (namedParameterCount > 0 && unnamedParameterCount > 0) {
            throw new SQLException("You can't mix named and traditional ? placeholders. You have " + namedParameterCount + " named parameter(s) and " + unnamedParameterCount + " traditonal placeholder(s) in [" + originalSql + "]");
        }
        for (int i = 0; i < parameterNames.size(); ++i) {
            String paramName = parameterNames.get(i);
            paramArray[i] = paramSource.getValue(paramName);
        }
        return paramArray;
    }
}

