/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.Hasor;
import net.hasor.core.Matcher;
import net.hasor.core.MethodInterceptor;
import net.hasor.core.Module;
import net.hasor.core.Provider;
import net.hasor.core.classcode.matcher.AopMatchers;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.core.provider.SingleProvider;
import net.hasor.db.Level;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.core.JdbcOperationsProvider;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.core.JdbcTemplateProvider;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionTemplate;
import net.hasor.db.transaction.interceptor.TransactionInterceptor;
import net.hasor.db.transaction.interceptor.Transactional;
import net.hasor.db.transaction.provider.TransactionManagerProvider;
import net.hasor.db.transaction.provider.TransactionTemplateProvider;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcModule
implements Module {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<Level> loadLevel;
    private String dataSourceID;
    private Provider<DataSource> dataSource;

    public JdbcModule(Level loadLevel, DataSource dataSource) {
        this(new Level[]{loadLevel}, null, (Provider<DataSource>)new InstanceProvider(Hasor.assertIsNotNull((Object)dataSource)));
    }

    public JdbcModule(Level loadLevel, Provider<DataSource> dataSource) {
        this(new Level[]{loadLevel}, null, dataSource);
    }

    public JdbcModule(Level loadLevel, String name, DataSource dataSource) {
        this(new Level[]{loadLevel}, name, (Provider<DataSource>)new InstanceProvider(Hasor.assertIsNotNull((Object)dataSource)));
    }

    public JdbcModule(Level[] loadLevel, DataSource dataSource) {
        this(loadLevel, null, (Provider<DataSource>)new InstanceProvider(Hasor.assertIsNotNull((Object)dataSource)));
    }

    public JdbcModule(Level[] loadLevel, Provider<DataSource> dataSource) {
        this(loadLevel, null, dataSource);
    }

    public JdbcModule(Level[] loadLevel, String name, Provider<DataSource> dataSource) {
        Hasor.assertIsNotNull((Object)loadLevel, (String)"loadLevel is null.");
        Hasor.assertIsNotNull(dataSource, (String)"dataSource Provider is null.");
        this.loadLevel = new HashSet<Level>(Arrays.asList(loadLevel));
        this.dataSourceID = name;
        this.dataSource = dataSource;
    }

    public void loadModule(ApiBinder apiBinder) throws Throwable {
        boolean loadTran;
        boolean loadData = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.DataSource);
        boolean loadJdbc = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.Jdbc);
        boolean bl = loadTran = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.Tran);
        if (loadData) {
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(DataSource.class).toProvider(this.dataSource);
            } else {
                apiBinder.bindType(DataSource.class).nameWith(this.dataSourceID).toProvider(this.dataSource);
            }
        }
        if (loadJdbc) {
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(JdbcTemplate.class).toProvider((Provider)new JdbcTemplateProvider(this.dataSource));
                apiBinder.bindType(JdbcOperations.class).toProvider((Provider)new JdbcOperationsProvider(this.dataSource));
            } else {
                apiBinder.bindType(JdbcTemplate.class).nameWith(this.dataSourceID).toProvider((Provider)new JdbcTemplateProvider(this.dataSource));
                apiBinder.bindType(JdbcOperations.class).nameWith(this.dataSourceID).toProvider((Provider)new JdbcOperationsProvider(this.dataSource));
            }
        }
        if (loadTran) {
            TransactionManagerProvider managerProvider = new TransactionManagerProvider(this.dataSource);
            TransactionTemplateProvider templateProvider = new TransactionTemplateProvider(this.dataSource);
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(TransactionManager.class).toProvider((Provider)new SingleProvider((Provider)managerProvider));
                apiBinder.bindType(TransactionTemplate.class).toProvider((Provider)new SingleProvider((Provider)templateProvider));
            } else {
                apiBinder.bindType(TransactionManager.class).nameWith(this.dataSourceID).toProvider((Provider)new SingleProvider((Provider)managerProvider));
                apiBinder.bindType(TransactionTemplate.class).nameWith(this.dataSourceID).toProvider((Provider)new SingleProvider((Provider)templateProvider));
            }
            TransactionInterceptor tranInter = new TransactionInterceptor(this.dataSource);
            Matcher matcherClass = AopMatchers.annotatedWithClass(Transactional.class);
            Matcher matcherMethod = AopMatchers.annotatedWithMethod(Transactional.class);
            apiBinder.bindInterceptor(matcherClass, matcherMethod, (MethodInterceptor)tranInter);
        }
    }
}

