/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.Codecs;
import net.hamnaberg.json.codec.DecodeResult;
import net.hamnaberg.json.codec.JsonCodec;
import net.hamnaberg.json.codec.reflection.Factory;
import net.hamnaberg.json.codec.reflection.FieldParam;
import net.hamnaberg.json.codec.reflection.MethodParam;
import net.hamnaberg.json.codec.reflection.Param;

public final class ReflectionCodec<A>
implements JsonCodec<A> {
    private final Class<A> type;
    private final Map<String, JsonCodec<?>> codecs;
    private final List<Param> fields;
    private final Factory<A> factory;
    private static Map<Class<?>, JsonCodec<?>> defaultCodecs;

    public ReflectionCodec(Class<A> type) {
        this(type, Collections.emptyMap());
    }

    public ReflectionCodec(Class<A> type, Map<String, JsonCodec<?>> codecs) {
        this(type, codecs, p -> true, Optional.empty());
    }

    public ReflectionCodec(Class<A> type, Map<String, JsonCodec<?>> codecs, Predicate<Param> predicate) {
        this(type, codecs, predicate, Optional.empty());
    }

    public ReflectionCodec(Class<A> type, Map<String, JsonCodec<?>> codecs, Predicate<Param> predicate, Optional<String> factoryMethod) {
        this.type = type;
        this.codecs = codecs;
        this.fields = ReflectionCodec.getFields(type).stream().filter(predicate).collect(Collectors.toUnmodifiableList());
        this.factory = factoryMethod.map(n -> Factory.factory(type, n, this.fields)).orElse(Factory.constructor(type, this.fields));
    }

    public Json.JValue toJson(A value) {
        LinkedHashMap map = new LinkedHashMap();
        for (Param field : this.fields) {
            Optional<JsonCodec<Object>> codec = this.getCodec(field);
            Optional<Object> optValue = field.get(value);
            Optional opt = optValue.flatMap(o -> codec.map(c -> c.toJson(o)));
            opt.ifPresent(v -> map.put(field.getName(), v));
        }
        return map.isEmpty() ? Json.jNull() : Json.jObject(map);
    }

    public DecodeResult<A> fromJson(Json.JValue value) {
        Json.JObject object = value.asJsonObjectOrEmpty();
        ArrayList arguments = new ArrayList();
        for (Param field : this.fields) {
            JsonCodec<Object> codec = this.getCodec(field).orElseThrow(() -> {
                throw new NoSuchElementException("Missing codec for " + field.getName());
            });
            DecodeResult result = DecodeResult.decode((Json.JObject)object, (String)field.getName(), codec);
            result.forEach(arguments::add);
        }
        try {
            return DecodeResult.ok(this.factory.invoke(List.copyOf(arguments)));
        }
        catch (Exception e) {
            return DecodeResult.fail((String)e.getMessage());
        }
    }

    private Optional<JsonCodec<Object>> getCodec(Param field) {
        return Optional.ofNullable(this.codecs.getOrDefault(field.getName(), defaultCodecs.get(field.getType())));
    }

    public String toString() {
        return String.format("ReflectionCodec(%s)", this.type.getName());
    }

    private static String getterOf(String field) {
        return "get" + Character.toUpperCase(field.charAt(0)) + field.substring(1);
    }

    private static <A> List<Param> getFields(Class<A> type) {
        Field[] declared = type.getDeclaredFields();
        ArrayList<Param> fields = new ArrayList<Param>(declared.length);
        for (Field field : declared) {
            int modifiers = field.getModifiers();
            if (!Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) continue;
            fields.add(new FieldParam(field.getName(), field));
        }
        if (fields.isEmpty()) {
            for (Field field : declared) {
                try {
                    Method method = type.getDeclaredMethod(ReflectionCodec.getterOf(field.getName()), new Class[0]);
                    if (method == null) continue;
                    fields.add(new MethodParam(field.getName(), method));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return List.copyOf(fields);
    }

    static {
        HashMap<Class, JsonCodec> codecs = new HashMap<Class, JsonCodec>();
        codecs.put(String.class, Codecs.CString);
        codecs.put(Integer.class, Codecs.CInt);
        codecs.put(Integer.TYPE, Codecs.CInt);
        codecs.put(Double.TYPE, Codecs.CDouble);
        codecs.put(Long.TYPE, Codecs.CLong);
        codecs.put(Long.class, Codecs.CLong);
        codecs.put(Double.class, Codecs.CDouble);
        codecs.put(BigInteger.class, Codecs.CNumber);
        codecs.put(Number.class, Codecs.CNumber);
        codecs.put(Boolean.class, Codecs.CBoolean);
        defaultCodecs = Collections.unmodifiableMap(codecs);
    }
}

