/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import java.lang.reflect.Method;
import java.util.Optional;
import net.hamnaberg.json.codec.reflection.Param;

class MethodParam
implements Param {
    public final String name;
    private final Method method;

    public MethodParam(String name, Method method) {
        this.name = name;
        this.method = method;
    }

    @Override
    public Optional<Object> get(Object value) {
        try {
            return Optional.ofNullable(this.method.invoke(value, new Object[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return "MethodParam{name='" + this.name + "', type=" + this.method.getReturnType().getName() + "}";
    }
}

