/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import java.lang.reflect.Field;
import java.util.Optional;
import net.hamnaberg.json.codec.reflection.Param;

class FieldParam
implements Param {
    private final String name;
    private final Field field;

    public FieldParam(String name, Field field) {
        this.name = name;
        this.field = field;
    }

    @Override
    public Optional<Object> get(Object value) {
        try {
            return Optional.ofNullable(this.field.get(value));
        }
        catch (IllegalAccessException e) {
            return Optional.empty();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    public String toString() {
        return "FieldParam{name='" + this.name + "', type=" + this.field.getType().getName() + "}";
    }
}

