/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import net.hamnaberg.json.codec.reflection.Param;

public interface Factory<A> {
    public A invoke(List<Object> var1);

    public static <A> Factory<A> constructor(Class<A> type, List<Param> params) {
        List<Class> types = params.stream().map(Param::getType).collect(Collectors.toList());
        try {
            Constructor ctor = type.getConstructor(types.toArray(new Class[0]));
            return params1 -> {
                try {
                    return ctor.newInstance(params1.toArray());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <A> Factory<A> factory(Class<A> type, String name, List<Param> params) {
        List<Class> types = params.stream().map(Param::getType).collect(Collectors.toList());
        try {
            Method method = type.getDeclaredMethod(name, types.toArray(new Class[params.size()]));
            return params1 -> {
                try {
                    return method.invoke(null, params1.toArray());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

