/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.Codecs;
import net.hamnaberg.json.codec.DecodeResult;
import net.hamnaberg.json.codec.JsonCodec;
import net.hamnaberg.json.codec.reflection.ReflectionCodec;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionCodecTest {
    @Test
    public void personReflection() {
        Json.JObject value = Json.jObject((Map)new LinkedHashMap<String, Json.JValue>(){
            {
                this.put("name", Json.jString((String)"Erlend Hamnaberg"));
                this.put("age", Json.jNumber((int)34));
                this.put("address", Json.jObject((Map.Entry)Json.tuple((String)"street", (Json.JValue)Json.jString((String)"Ensj\u00f8veien")), (Map.Entry[])new Map.Entry[]{Json.tuple((String)"city", (Json.JValue)Json.jString((String)"Oslo"))}));
            }
        });
        ReflectionCodec aCodec = new ReflectionCodec(Address.class);
        ReflectionCodec personCodec = new ReflectionCodec(Person.class, Collections.singletonMap("address", aCodec));
        Person person = new Person("Erlend Hamnaberg", 34, new Address("Ensj\u00f8veien", "Oslo"));
        DecodeResult personOpt = personCodec.fromJson((Json.JValue)value);
        Assert.assertTrue((boolean)personOpt.isOk());
        Assert.assertEquals((Object)person, (Object)personOpt.unsafeGet());
        Json.JValue encoded = personCodec.toJson((Object)person);
        Assert.assertEquals((Object)value, (Object)encoded);
    }

    @Test
    public void consultantReflectionWithArrays() {
        Json.JObject value = Json.jObject((String)"name", (Json.JValue)Json.jString((String)"Erlend Hamnaberg"), (String)"workplaces", (Json.JValue)Json.jArray(List.of(Json.jObject((Map.Entry)Json.tuple((String)"street", (Json.JValue)Json.jString((String)"Ensj\u00f8veien")), (Map.Entry[])new Map.Entry[]{Json.tuple((String)"city", (Json.JValue)Json.jString((String)"Oslo"))}), Json.jObject((Map.Entry)Json.tuple((String)"street", (Json.JValue)Json.jString((String)"Money, Money, Money")), (Map.Entry[])new Map.Entry[]{Json.tuple((String)"city", (Json.JValue)Json.jString((String)"Oslo"))}))));
        ReflectionCodec aCodec = new ReflectionCodec(Address.class);
        Map<String, JsonCodec> codecs = Collections.singletonMap("workplaces", Codecs.listCodec((JsonCodec)aCodec));
        ReflectionCodec consultantCodec = new ReflectionCodec(Consultant.class, codecs);
        ReflectionCodec consultantCodecFactory = new ReflectionCodec(Consultant.class, codecs, p -> true, Optional.of("create"));
        Consultant consultant = new Consultant("Erlend Hamnaberg", List.of(new Address("Ensj\u00f8veien", "Oslo"), new Address("Money, Money, Money", "Oslo")));
        DecodeResult consultantOpt = consultantCodec.fromJson((Json.JValue)value);
        DecodeResult consultantFactoryOpt = consultantCodecFactory.fromJson((Json.JValue)value);
        Assert.assertTrue((boolean)consultantOpt.isOk());
        Assert.assertEquals((Object)consultant, (Object)consultantOpt.unsafeGet());
        Assert.assertTrue((boolean)consultantFactoryOpt.isOk());
        Assert.assertEquals((Object)consultant, (Object)consultantFactoryOpt.unsafeGet());
        Json.JValue encoded = consultantCodec.toJson((Object)consultant);
        Assert.assertEquals((Object)value, (Object)encoded);
    }

    private static class Address {
        public final String street;
        public final String city;

        public Address(String street, String city) {
            this.street = street;
            this.city = city;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Address address = (Address)o;
            if (!this.street.equals(address.street)) {
                return false;
            }
            return this.city.equals(address.city);
        }

        public int hashCode() {
            int result = this.street.hashCode();
            result = 31 * result + this.city.hashCode();
            return result;
        }
    }

    private static class Person {
        public final String name;
        public final int age;
        public final Address address;

        public Person(String name, int age, Address address) {
            this.name = name;
            this.age = age;
            this.address = address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.age != person.age) {
                return false;
            }
            return this.name.equals(person.name) && this.address.equals(person.address);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.address.hashCode() + this.age;
        }
    }

    private static class Consultant {
        public final String name;
        public final List<Address> workplaces;

        public Consultant(String name, List<Address> workplaces) {
            this.name = name;
            this.workplaces = workplaces;
        }

        public static Consultant create(String name, List<Address> workplaces) {
            return new Consultant(name, workplaces);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Consultant person = (Consultant)o;
            return this.name.equals(person.name) && this.workplaces.equals(person.workplaces);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.workplaces.hashCode();
        }
    }
}

