package net.hamnaberg.json.codec.reflection;

import java.lang.reflect.Field;
import java.util.Optional;

class FieldParam implements Param {
    private final String name;
    private final Field field;

    public FieldParam(String name, Field field) {
        this.name = name;
        this.field = field;
    }

    public Optional<Object> get(Object value) {
        try {
            return Optional.ofNullable(field.get(value));
        } catch (IllegalAccessException e) {
            return Optional.empty();
        }
    }

    public String getName() {
        return name;
    }

    public Class<?> getType() {
        return field.getType();
    }

    @Override
    public String toString() {
        return "FieldParam{" +
                "name='" + name + '\'' +
                ", type=" + field.getType().getName() +
                '}';
    }
}
