/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import io.vavr.control.Option;
import java.lang.reflect.Method;
import net.hamnaberg.json.codec.reflection.Param;

class MethodParam
implements Param {
    public final String name;
    private final Method method;

    public MethodParam(String name, Method method) {
        this.name = name;
        this.method = method;
    }

    @Override
    public Option<Object> get(Object value) {
        try {
            return Option.of((Object)this.method.invoke(value, new Object[0]));
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return "MethodParam{name='" + this.name + '\'' + ", type=" + this.method.getReturnType().getName() + '}';
    }
}

