/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import io.vavr.control.Option;
import java.lang.reflect.Field;
import net.hamnaberg.json.codec.reflection.Param;

class FieldParam
implements Param {
    private final String name;
    private final Field field;

    public FieldParam(String name, Field field) {
        this.name = name;
        this.field = field;
    }

    @Override
    public Option<Object> get(Object value) {
        try {
            return Option.of((Object)this.field.get(value));
        }
        catch (IllegalAccessException e) {
            return Option.none();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    public String toString() {
        return "FieldParam{name='" + this.name + '\'' + ", type=" + this.field.getType().getName() + '}';
    }
}

