/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import io.vavr.collection.List;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.hamnaberg.json.codec.reflection.Param;

public interface Factory<A> {
    public A invoke(List<Object> var1);

    public static <A> Factory<A> constructor(Class<A> type, List<Param> params) {
        List types = params.map(Param::getType);
        try {
            Constructor ctor = type.getConstructor(types.toJavaList().toArray(new Class[params.size()]));
            return params1 -> {
                try {
                    return ctor.newInstance(params1.toJavaArray());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <A> Factory<A> factory(Class<A> type, String name, List<Param> params) {
        List types = params.map(Param::getType);
        try {
            Method method = type.getDeclaredMethod(name, types.toJavaList().toArray(new Class[params.size()]));
            return params1 -> {
                try {
                    return method.invoke(null, params1.toJavaArray());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

