/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javaslang.collection.List;
import javaslang.control.Option;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.Codecs;
import net.hamnaberg.json.codec.DecodeJson;
import net.hamnaberg.json.codec.DecodeResult;
import net.hamnaberg.json.codec.JsonCodec;
import net.hamnaberg.json.codec.reflection.Factory;
import net.hamnaberg.json.codec.reflection.FieldParam;
import net.hamnaberg.json.codec.reflection.MethodParam;
import net.hamnaberg.json.codec.reflection.Param;

public final class ReflectionCodec<A>
implements JsonCodec<A> {
    private final Class<A> type;
    private final Map<String, JsonCodec<?>> codecs;
    private final List<Param> fields;
    private final Factory<A> factory;
    private static Map<Class<?>, JsonCodec<?>> defaultCodecs;

    public ReflectionCodec(Class<A> type) {
        this(type, Collections.emptyMap());
    }

    public ReflectionCodec(Class<A> type, Map<String, JsonCodec<?>> codecs) {
        this(type, codecs, p -> true, (Option<String>)Option.none());
    }

    public ReflectionCodec(Class<A> type, Map<String, JsonCodec<?>> codecs, Predicate<Param> predicate) {
        this(type, codecs, predicate, (Option<String>)Option.none());
    }

    public ReflectionCodec(Class<A> type, Map<String, JsonCodec<?>> codecs, Predicate<Param> predicate, Option<String> factoryMethod) {
        this.type = type;
        this.codecs = codecs;
        this.fields = ReflectionCodec.getFields(type).filter(predicate);
        this.factory = (Factory)factoryMethod.map(n -> Factory.factory(type, n, this.fields)).getOrElse(Factory.constructor(type, this.fields));
    }

    public Option<Json.JValue> toJson(A value) {
        LinkedHashMap map = new LinkedHashMap();
        for (Param field : this.fields) {
            Option<JsonCodec<Object>> codec = this.getCodec(field);
            Option<Object> optValue = field.get(value);
            Option opt = optValue.flatMap(o -> codec.flatMap(c -> c.toJson(o)));
            opt.forEach(v -> map.put(field.getName(), v));
        }
        return map.isEmpty() ? Option.none() : Option.some((Object)Json.jObject(map));
    }

    public DecodeResult<A> fromJson(Json.JValue value) {
        Json.JObject object = value.asJsonObjectOrEmpty();
        ArrayList arguments = new ArrayList();
        for (Param field : this.fields) {
            JsonCodec codec = (JsonCodec)this.getCodec(field).getOrElseThrow(() -> {
                throw new NoSuchElementException("Missing codec for " + field.getName());
            });
            DecodeResult result = DecodeResult.decode((Json.JObject)object, (String)field.getName(), (DecodeJson)codec);
            result.forEach(arguments::add);
        }
        try {
            return DecodeResult.ok(this.factory.invoke((List<Object>)List.ofAll(arguments)));
        }
        catch (Exception e) {
            return DecodeResult.fail((String)e.getMessage());
        }
    }

    private Option<JsonCodec<Object>> getCodec(Param field) {
        return Option.of(this.codecs.getOrDefault(field.getName(), defaultCodecs.get(field.getType())));
    }

    public String toString() {
        return String.format("ReflectionCodec(%s)", this.type.getName());
    }

    private static String getterOf(String field) {
        return "get" + Character.toUpperCase(field.charAt(0)) + field.substring(1);
    }

    private static <A> List<Param> getFields(Class<A> type) {
        Field[] declared = type.getDeclaredFields();
        ArrayList<Param> fields = new ArrayList<Param>(declared.length);
        for (Field field : declared) {
            int modifiers = field.getModifiers();
            if (!Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) continue;
            fields.add(new FieldParam(field.getName(), field));
        }
        if (fields.isEmpty()) {
            for (Field field : declared) {
                try {
                    Method method = type.getDeclaredMethod(ReflectionCodec.getterOf(field.getName()), new Class[0]);
                    if (method == null) continue;
                    fields.add(new MethodParam(field.getName(), method));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return List.ofAll(fields);
    }

    static {
        HashMap<Class, JsonCodec> codecs = new HashMap<Class, JsonCodec>();
        codecs.put(String.class, Codecs.StringCodec);
        codecs.put(Integer.class, Codecs.intCodec);
        codecs.put(Integer.TYPE, Codecs.intCodec);
        codecs.put(Double.TYPE, Codecs.doubleCodec);
        codecs.put(Long.TYPE, Codecs.longCodec);
        codecs.put(Long.class, Codecs.longCodec);
        codecs.put(Double.class, Codecs.doubleCodec);
        codecs.put(BigInteger.class, Codecs.numberCodec);
        codecs.put(Number.class, Codecs.numberCodec);
        codecs.put(Boolean.class, Codecs.booleanCodec);
        defaultCodecs = Collections.unmodifiableMap(codecs);
    }
}

