/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.patch;

import java.util.LinkedHashMap;
import javaslang.collection.Map;
import javaslang.control.Option;
import net.hamnaberg.json.Json;

public abstract class MergePatch {
    private MergePatch() {
    }

    public static Json.JValue diff(Json.JValue obj1, Json.JValue obj2) {
        if (!obj1.isObject() || !obj2.isObject()) {
            return obj2;
        }
        Json.JObject object1 = (Json.JObject)obj1.asJsonObject().getOrElse((Object)Json.jEmptyObject());
        Json.JObject object2 = (Json.JObject)obj2.asJsonObject().getOrElse((Object)Json.jEmptyObject());
        LinkedHashMap map = new LinkedHashMap();
        object1.forEach((k, v) -> {
            if (object2.containsKey(k)) {
                Json.JValue value = object2.getOrDefault(k, (Json.JValue)Json.jNull());
                if (!value.equals(v)) {
                    map.put(k, MergePatch.diff(v, value));
                }
            } else {
                map.put(k, Json.jNull());
            }
        });
        object2.forEach((k, v) -> {
            if (!object1.containsKey(k)) {
                map.put(k, v);
            }
        });
        return Json.jObject(map);
    }

    public static Json.JValue patch(Json.JValue target, Json.JValue patchValue) {
        Option maybeTarget = target.asJsonObject();
        if (patchValue.asJsonObject().isEmpty()) {
            return patchValue;
        }
        Json.JObject object = (Json.JObject)maybeTarget.getOrElse((Object)Json.jEmptyObject());
        Json.JObject patch = (Json.JObject)patchValue.asJsonObject().getOrElse((Object)Json.jEmptyObject());
        Map map = object.getValue();
        patch.forEach((k, v) -> {
            if (v.asJsonNull().isDefined()) {
                if (map.containsKey(k)) {
                    map.remove(k);
                }
            } else if (map.containsKey(k)) {
                map.put(k, (Object)MergePatch.patch((Json.JValue)map.apply(k), v));
            } else {
                map.put(k, (Object)MergePatch.patch((Json.JValue)Json.jEmptyObject(), v));
            }
        });
        return Json.jObject((Map)map);
    }
}

