/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.patch;

import java.util.function.Function;
import javaslang.collection.List;
import javaslang.control.Option;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.patch.Operation;
import net.hamnaberg.json.pointer.JsonPointer;

public final class JsonPatch
implements Function<Json.JValue, Json.JValue> {
    private final List<Operation> operations;

    public static JsonPatch fromArray(Json.JArray array) {
        List operations = array.mapToList(j -> Operation.fromJson(j.asJsonObjectOrEmpty()));
        return new JsonPatch((List<Operation>)operations);
    }

    public JsonPatch() {
        this((List<Operation>)List.empty());
    }

    private JsonPatch(List<Operation> operations) {
        this.operations = operations;
    }

    public JsonPatch add(String path, Json.JValue value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    public JsonPatch add(JsonPointer path, Json.JValue value) {
        return this.op(Operation.Op.Add, (Option<JsonPointer>)Option.none(), path, (Option<Json.JValue>)Option.of((Object)value));
    }

    public JsonPatch remove(String path) {
        return this.remove(JsonPointer.compile((String)path));
    }

    public JsonPatch remove(JsonPointer path) {
        return this.op(Operation.Op.Remove, (Option<JsonPointer>)Option.none(), path, (Option<Json.JValue>)Option.none());
    }

    public JsonPatch replace(String path, Json.JValue value) {
        return this.replace(JsonPointer.compile((String)path), value);
    }

    public JsonPatch replace(JsonPointer path, Json.JValue value) {
        return this.op(Operation.Op.Replace, (Option<JsonPointer>)Option.none(), path, (Option<Json.JValue>)Option.of((Object)value));
    }

    public JsonPatch test(String path, Json.JValue value) {
        return this.test(JsonPointer.compile((String)path), value);
    }

    public JsonPatch test(JsonPointer path, Json.JValue value) {
        return this.op(Operation.Op.Test, (Option<JsonPointer>)Option.none(), path, (Option<Json.JValue>)Option.of((Object)value));
    }

    public JsonPatch copy(String from, String path) {
        return this.copy(JsonPointer.compile((String)from), JsonPointer.compile((String)path));
    }

    public JsonPatch copy(JsonPointer from, JsonPointer path) {
        return this.op(Operation.Op.Copy, (Option<JsonPointer>)Option.of((Object)from), path, (Option<Json.JValue>)Option.none());
    }

    public JsonPatch move(String from, String path) {
        return this.move(JsonPointer.compile((String)from), JsonPointer.compile((String)path));
    }

    public JsonPatch move(JsonPointer from, JsonPointer path) {
        return this.op(Operation.Op.Move, (Option<JsonPointer>)Option.of((Object)from), path, (Option<Json.JValue>)Option.none());
    }

    private JsonPatch op(Operation.Op op, Option<JsonPointer> from, JsonPointer path, Option<Json.JValue> value) {
        return new JsonPatch((List<Operation>)this.operations.append((Object)new Operation(op, from, path, value)));
    }

    @Override
    public Json.JValue apply(Json.JValue json) {
        Json.JValue modified = json;
        for (Operation op : this.operations) {
            switch (op.op) {
                case Add: {
                    modified = op.path.add(modified, (Json.JValue)op.value.getOrElseThrow(() -> new IllegalStateException("Missing value")));
                    break;
                }
                case Remove: {
                    modified = op.path.remove(modified);
                    break;
                }
                case Replace: {
                    modified = op.path.replace(modified, (Json.JValue)op.value.getOrElseThrow(() -> new IllegalStateException("Missing value")));
                    break;
                }
                case Move: {
                    modified = op.path.move(json, (JsonPointer)op.from.getOrElseThrow(() -> new IllegalStateException("Missing from")));
                    break;
                }
                case Copy: {
                    modified = op.path.copy(json, (JsonPointer)op.from.getOrElseThrow(() -> new IllegalStateException("Missing from")));
                    break;
                }
                case Test: {
                    modified = op.path.test(json, (Json.JValue)op.value.getOrElseThrow(() -> new IllegalStateException("Missing value"))) ? modified : modified;
                }
            }
        }
        return modified;
    }

    public Json.JArray toJson() {
        return Json.jArray((Iterable)this.operations.map(Operation::toJson));
    }
}

