/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.patch;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.pointer.JsonPointer;

public class Operation {
    public Op op;
    public Optional<JsonPointer> from;
    public JsonPointer path;
    public Optional<Json.JValue> value;

    public Operation(Op op, Optional<String> from, String path, Optional<Json.JValue> value) {
        this.op = op;
        this.from = from.map(JsonPointer::compile);
        this.path = JsonPointer.compile((String)path);
        this.value = value;
        if (EnumSet.of(Op.Add, Op.Replace, Op.Test).contains((Object)op) && !value.isPresent()) {
            throw new IllegalArgumentException(String.format("Op '%s' requires a value", op.value));
        }
    }

    public static Operation fromJson(Json.JObject object) {
        return new Operation(Op.fromString(object.getAsStringOrEmpty("op")), object.getAsString("from"), object.getAsStringOrEmpty("path"), object.get("value"));
    }

    public Json.JObject toJson() {
        LinkedHashMap<String, Json.JString> map = new LinkedHashMap<String, Json.JString>();
        map.put("op", Json.jString((String)this.op.value));
        this.from.ifPresent(v -> {
            Json.JValue cfr_ignored_0 = (Json.JValue)map.put("from", Json.jString((String)v.toString()));
        });
        map.put("path", Json.jString((String)this.path.toString()));
        this.value.ifPresent(v -> map.put("value", (Json.JString)v));
        return Json.jObject(map);
    }

    static enum Op {
        Add("add"),
        Remove("remove"),
        Replace("replace"),
        Move("move"),
        Copy("copy"),
        Test("test");

        public final String value;

        private Op(String value) {
            this.value = value;
        }

        public static Op fromString(String name) {
            for (Op op : Op.values()) {
                if (!op.value.equals(name.trim())) continue;
                return op;
            }
            throw new IllegalArgumentException(String.format("'%s' is not a legal value for Op", name));
        }
    }
}

