/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.patch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.patch.Operation;

public final class JsonPatch
implements Function<Json.JValue, Json.JValue> {
    private final List<Operation> operations;

    public static JsonPatch fromArray(Json.JArray array) {
        List operations = array.mapToList(j -> Operation.fromJson(j.asJsonObjectOrEmpty()));
        return new JsonPatch(operations);
    }

    public JsonPatch() {
        this(Collections.emptyList());
    }

    private JsonPatch(List<Operation> operations) {
        this.operations = operations;
    }

    public JsonPatch add(String path, Json.JValue value) {
        return this.op(Operation.Op.Add, Optional.empty(), path, Optional.of(value));
    }

    public JsonPatch remove(String path) {
        return this.op(Operation.Op.Remove, Optional.empty(), path, Optional.empty());
    }

    public JsonPatch replace(String path, Json.JValue value) {
        return this.op(Operation.Op.Replace, Optional.empty(), path, Optional.of(value));
    }

    public JsonPatch test(String path, Json.JValue value) {
        return this.op(Operation.Op.Test, Optional.empty(), path, Optional.of(value));
    }

    public JsonPatch copy(String from, String path) {
        return this.op(Operation.Op.Copy, Optional.of(from), path, Optional.empty());
    }

    public JsonPatch move(String from, String path) {
        return this.op(Operation.Op.Move, Optional.of(from), path, Optional.empty());
    }

    private JsonPatch op(Operation.Op op, Optional<String> from, String path, Optional<Json.JValue> value) {
        ArrayList<Operation> list = new ArrayList<Operation>(this.operations);
        list.add(new Operation(op, from, path, value));
        return new JsonPatch(Collections.unmodifiableList(list));
    }

    @Override
    public Json.JValue apply(Json.JValue json) {
        Json.JValue modified = json;
        for (Operation op : this.operations) {
            switch (op.op) {
                case Add: {
                    modified = op.path.add(modified, op.value.orElseThrow(() -> new IllegalStateException("Missing value")));
                    break;
                }
                case Remove: {
                    modified = op.path.remove(modified);
                    break;
                }
                case Replace: {
                    modified = op.path.replace(modified, op.value.orElseThrow(() -> new IllegalStateException("Missing value")));
                    break;
                }
                case Move: {
                    modified = op.path.move(json, op.from.orElseThrow(() -> new IllegalStateException("Missing from")));
                    break;
                }
                case Copy: {
                    modified = op.path.copy(json, op.from.orElseThrow(() -> new IllegalStateException("Missing from")));
                    break;
                }
                case Test: {
                    modified = op.path.test(json, op.value.orElseThrow(() -> new IllegalStateException("Missing value"))) ? modified : modified;
                }
            }
        }
        return modified;
    }

    public Json.JArray toJson() {
        return Json.jArray((Iterable)this.operations.stream().map(Operation::toJson).collect(Collectors.toList()));
    }
}

