/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import java.io.Writer;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.io.JsonSerializer;
import org.glassfish.json.JsonFactory;

public final class JavaxStreamingGenerator
implements JsonSerializer {
    public void write(Json.JValue value, Writer writer) {
        try (JsonGenerator generator = Json.createGenerator((Writer)writer);){
            generator.write(this.convert(value));
        }
    }

    public JsonValue convert(Json.JValue value) {
        return (JsonValue)value.fold(j -> JsonFactory.jsonString(j.value), j -> j.value ? JsonValue.TRUE : JsonValue.FALSE, j -> JsonFactory.jsonNumber(j.value), j -> {
            JsonObjectBuilder jb = Json.createObjectBuilder();
            for (Map.Entry entry : j) {
                jb.add((String)entry.getKey(), this.convert((Json.JValue)entry.getValue()));
            }
            return jb.build();
        }, j -> {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (Json.JValue v : j) {
                arrayBuilder.add(this.convert(v));
            }
            return arrayBuilder.build();
        }, () -> JsonValue.NULL);
    }
}

