/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.DecodeJson;
import net.hamnaberg.json.codec.DecodeResult;
import net.hamnaberg.json.io.JsonParseException;

public abstract class JsonParser {
    public final Try<Json.JValue> parse(ReadableByteChannel channel) {
        return this.parse(Channels.newInputStream(channel));
    }

    public final Try<Json.JValue> parse(InputStream is) {
        return this.parse(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)));
    }

    public final Try<Json.JValue> parse(byte[] bytes) {
        return this.parse(new ByteArrayInputStream(bytes));
    }

    public final Try<Json.JValue> parse(String string) {
        return this.parse(new StringReader(string));
    }

    public final Try<Json.JValue> parse(Reader reader) {
        BufferedReader buf = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return Try.of((CheckedFunction0 & Serializable)() -> {
            try (BufferedReader r = buf;){
                Try<Json.JValue> try_ = this.parseImpl(r);
                return try_;
            }
        }).flatMap(Function.identity());
    }

    public final Json.JValue parseUnsafe(ReadableByteChannel channel) {
        return this.parseUnsafe(Channels.newInputStream(channel));
    }

    public final Json.JValue parseUnsafe(InputStream is) {
        return this.parseUnsafe(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)));
    }

    public final Json.JValue parseUnsafe(byte[] bytes) {
        return this.parseUnsafe(new ByteArrayInputStream(bytes));
    }

    public final Json.JValue parseUnsafe(String string) {
        return this.parseUnsafe(new StringReader(string));
    }

    public final Json.JValue parseUnsafe(Reader reader) {
        return (Json.JValue)this.parse(reader).getOrElseThrow(e -> {
            if (!(e instanceof JsonParseException)) {
                throw new JsonParseException((Throwable)e);
            }
            throw (JsonParseException)e;
        });
    }

    public final Option<Json.JValue> parseOpt(ReadableByteChannel is) {
        return this.parse(is).toOption();
    }

    public final Option<Json.JValue> parseOpt(byte[] bytes) {
        return this.parse(bytes).toOption();
    }

    public final Option<Json.JValue> parseOpt(InputStream is) {
        return this.parse(is).toOption();
    }

    public final Option<Json.JValue> parseOpt(String string) {
        return this.parse(string).toOption();
    }

    public final Option<Json.JValue> parseOpt(Reader reader) {
        return this.parse(reader).toOption();
    }

    public final <A> DecodeResult<A> decode(ReadableByteChannel is, DecodeJson<A> decoder) {
        return this.decode(this.parse(is), decoder);
    }

    public final <A> DecodeResult<A> decode(byte[] bytes, DecodeJson<A> decoder) {
        return this.decode(this.parse(bytes), decoder);
    }

    public final <A> DecodeResult<A> decode(InputStream is, DecodeJson<A> decoder) {
        return this.decode(this.parse(is), decoder);
    }

    public final <A> DecodeResult<A> decode(String string, DecodeJson<A> decoder) {
        return this.decode(this.parse(string), decoder);
    }

    public final <A> DecodeResult<A> decode(Reader reader, DecodeJson<A> decoder) {
        return this.decode(this.parse(reader), decoder);
    }

    public final <A> DecodeResult<A> decode(Try<Json.JValue> parsed, DecodeJson<A> decoder) {
        return (DecodeResult)parsed.map(arg_0 -> decoder.fromJson(arg_0)).getOrElseGet(t -> DecodeResult.fail((String)t.getMessage()));
    }

    protected abstract Try<Json.JValue> parseImpl(Reader var1);
}

