/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.io.JsonSerializer;
import org.junit.Assert;
import org.junit.Test;

public class JsonSerializerTest {
    @Test
    public void writer() throws IOException {
        Json.JObject object = Json.jObject((String)"meh", (String)"hello");
        try (StringWriter s = new StringWriter();){
            JsonSerializer.write((Json.JValue)object, (Writer)s);
            String expected = "{\"meh\":\"hello\"}";
            Assert.assertEquals((Object)expected, (Object)s.toString());
        }
    }

    @Test
    public void stream() throws IOException {
        Json.JObject object = Json.jObject((String)"meh", (String)"hello");
        try (ByteArrayOutputStream s = new ByteArrayOutputStream();){
            JsonSerializer.write((Json.JValue)object, (OutputStream)s);
            String expected = "{\"meh\":\"hello\"}";
            Assert.assertEquals((Object)expected, (Object)s.toString("UTF-8"));
        }
    }

    @Test
    public void string() throws IOException {
        Json.JObject object = Json.jObject((String)"meh", (String)"hello");
        String expected = "{\"meh\":\"hello\"}";
        Assert.assertEquals((Object)expected, (Object)JsonSerializer.writeToString((Json.JValue)object));
    }
}

