package googleapis.firebase

import io.circe._

sealed abstract class WebAppState(val value: String) extends Product with Serializable
object WebAppState {

  /** Unspecified state.
    */
  case object STATE_UNSPECIFIED extends WebAppState("STATE_UNSPECIFIED")

  /** The App is active.
    */
  case object ACTIVE extends WebAppState("ACTIVE")

  /** The App has been soft-deleted. After an App has been in the `DELETED` state for more than 30 days, it is considered expired and will be permanently deleted. Up until this time, you can restore the App by calling `Undelete` ([Android](projects.androidApps/undelete) | [iOS](projects.iosApps/undelete) | [web](projects.webApps/undelete)).
    */
  case object DELETED extends WebAppState("DELETED")
  val values = List(STATE_UNSPECIFIED, ACTIVE, DELETED)
  def fromString(input: String): Either[String, WebAppState] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for WebAppState")
  implicit val decoder: Decoder[WebAppState] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[WebAppState] = Encoder[String].contramap(_.value)
}
