package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class WebAppConfig(
    /** The sender ID for use with Firebase Cloud Messaging.
      */
    messagingSenderId: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, find the URL of the default Realtime Database instance using the [list endpoint](https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list) within the Firebase Realtime Database REST API. If the default instance for the Project has not yet been provisioned, the return might not contain a default instance. Note that the config that's generated for the Firebase console or the Firebase CLI uses the Realtime Database endpoint to populate this value for that config._ The URL of the default Firebase Realtime Database instance.
      */
    databaseURL: Option[String] = None,
    /** Optional. Duplicate field for the URL of the default Realtime Database instances (if the default instance has been provisioned). If the request asks for the V2 config format, this field will be populated instead of `realtime_database_instance_uri`.
      */
    realtimeDatabaseUrl: Option[String] = None,
    /** The domain Firebase Auth configures for OAuth redirects, in the format: PROJECT_ID.firebaseapp.com
      */
    authDomain: Option[String] = None,
    /** Immutable. A user-assigned unique identifier for the `FirebaseProject`.
      */
    projectId: Option[String] = None,
    /** The [`keyString`](https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string) of the API key associated with the `WebApp`. Note that this value is _not_ the [`apiKeyId`](../projects.webApps#WebApp.FIELDS.api_key_id) (the UID) of the API key associated with the `WebApp`.
      */
    apiKey: Option[String] = None,
    /** Version of the config specification.
      */
    version: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, use product-specific REST APIs to find the location of each resource in a Project. This field may not be populated, especially for newly provisioned projects after October 30, 2024._ The ID of the Project's ["location for default Google Cloud resources"](https://firebase.google.com/docs/projects/locations#default-cloud-location), which are resources associated with Google App Engine. The location is one of the available [App Engine locations](https://cloud.google.com/about/locations#region). This field is omitted if the location for default Google Cloud resources has not been set.
      */
    locationId: Option[String] = None,
    /** Output only. Immutable. The globally unique, Google-assigned canonical identifier for the Project. Use this identifier when configuring integrations and/or making API calls to Google Cloud or third-party services.
      */
    projectNumber: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, find the name of the default Cloud Storage for Firebase bucket using the [list endpoint](https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list) within the Cloud Storage for Firebase REST API. If the default bucket for the Project has not yet been provisioned, the return might not contain a default bucket. Note that the config that's generated for the Firebase console or the Firebase CLI uses the Cloud Storage for Firebase endpoint to populate this value for that config._ The name of the default Cloud Storage for Firebase bucket.
      */
    storageBucket: Option[String] = None,
    /** Immutable. The globally unique, Firebase-assigned identifier for the `WebApp`.
      */
    appId: Option[String] = None,
    /** The unique Google-assigned identifier of the Google Analytics web stream associated with the `WebApp`. Firebase SDKs use this ID to interact with Google Analytics APIs. This field is only present if the `WebApp` is linked to a web stream in a Google Analytics App + Web property. Learn more about this ID and Google Analytics web streams in the [Analytics documentation](https://support.google.com/analytics/answer/9304153). To generate a `measurementId` and link the `WebApp` with a Google Analytics web stream, call [`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnalytics). For apps using the Firebase JavaScript SDK v7.20.0 and later, Firebase dynamically fetches the `measurementId` when your app initializes Analytics. Having this ID in your config object is optional, but it does serve as a fallback in the rare case that the dynamic fetch fails.
      */
    measurementId: Option[String] = None,
)
object WebAppConfig {
  implicit val encoder: Encoder[WebAppConfig] = Encoder.instance { x =>
    Json.obj(
      "messagingSenderId" := x.messagingSenderId,
      "databaseURL" := x.databaseURL,
      "realtimeDatabaseUrl" := x.realtimeDatabaseUrl,
      "authDomain"
        := x.authDomain,
      "projectId" := x.projectId,
      "apiKey" := x.apiKey,
      "version" := x.version,
      "locationId" := x.locationId,
      "projectNumber" := x.projectNumber,
      "storageBucket" := x.storageBucket,
      "appId" := x.appId,
      "measurementId" := x.measurementId,
    )
  }
  implicit val decoder: Decoder[WebAppConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("messagingSenderId")
      v1 <- c.get[Option[String]]("databaseURL")
      v2 <- c.get[Option[String]]("realtimeDatabaseUrl")
      v3 <- c.get[Option[String]]("authDomain")
      v4 <- c.get[Option[String]]("projectId")
      v5 <- c.get[Option[String]]("apiKey")
      v6 <- c.get[Option[String]]("version")
      v7 <- c.get[Option[String]]("locationId")
      v8 <- c.get[Option[String]]("projectNumber")
      v9 <- c.get[Option[String]]("storageBucket")
      v10 <- c.get[Option[String]]("appId")
      v11 <- c.get[Option[String]]("measurementId")
    } yield WebAppConfig(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11)
  }
}
