package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class WebApp(
    /** The user-assigned display name for the `WebApp`.
      */
    displayName: Option[String] = None,
    /** Output only. If the App has been removed from the Project, this is the timestamp of when the App is considered expired and will be permanently deleted. After this time, the App cannot be undeleted (that is, restored to the Project). This value is only provided if the App is in the `DELETED` state.
      */
    expireTime: Option[String] = None,
    /** This checksum is computed by the server based on the value of other fields, and it may be sent with update requests to ensure the client has an up-to-date value before proceeding. Learn more about `etag` in Google's [AIP-154 standard](https://google.aip.dev/154#declarative-friendly-resources). This etag is strongly validated.
      */
    etag: Option[String] = None,
    /** The resource name of the WebApp, in the format: projects/PROJECT_IDENTIFIER /webApps/APP_ID
      * PROJECT_IDENTIFIER: the parent Project's [`ProjectNumber`](../projects#FirebaseProject.FIELDS.project_number) \*\*\*(recommended)\*\*\* or its [`ProjectId`](../projects#FirebaseProject.FIELDS.project_id). Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510). Note that the value for PROJECT_IDENTIFIER in any response body will be the `ProjectId`.
      * APP_ID: the globally unique, Firebase-assigned identifier for the App (see [`appId`](../projects.webApps#WebApp.FIELDS.app_id)).
      */
    name: Option[String] = None,
    /** Output only. The lifecycle state of the App.
      */
    state: Option[WebAppState] = None,
    /** The URLs where the `WebApp` is hosted.
      */
    appUrls: Option[List[String]] = None,
    /** Output only. Immutable. A user-assigned unique identifier of the parent FirebaseProject for the `WebApp`.
      */
    projectId: Option[String] = None,
    /** Output only. Immutable. A unique, Firebase-assigned identifier for the `WebApp`. This identifier is only used to populate the `namespace` value for the `WebApp`. For most use cases, use `appId` to identify or reference the App. The `webId` value is only unique within a `FirebaseProject` and its associated Apps.
      */
    webId: Option[String] = None,
    /** The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the `WebApp`. Be aware that this value is the UID of the API key, _not_ the [`keyString`](https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string) of the API key. The `keyString` is the value that can be found in the App's [configuration artifact](../../rest/v1beta1/projects.webApps/getConfig). If `api_key_id` is not set in requests to [`webApps.Create`](../../rest/v1beta1/projects.webApps/create), then Firebase automatically associates an `api_key_id` with the `WebApp`. This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned. In patch requests, `api_key_id` cannot be set to an empty value, and the new UID must have no restrictions or only have restrictions that are valid for the associated `WebApp`. We recommend using the [Google Cloud Console](https://console.cloud.google.com/apis/credentials) to manage API keys.
      */
    apiKeyId: Option[String] = None,
    /** Output only. Immutable. The globally unique, Firebase-assigned identifier for the `WebApp`. This identifier should be treated as an opaque token, as the data format is not specified.
      */
    appId: Option[String] = None,
)
object WebApp {
  implicit val encoder: Encoder[WebApp] = Encoder.instance { x =>
    Json.obj(
      "displayName" := x.displayName,
      "expireTime" := x.expireTime,
      "etag" := x.etag,
      "name" := x.name,
      "state" := x.state,
      "appUrls" := x.appUrls,
      "projectId" := x.projectId,
      "webId" := x.webId,
      "apiKeyId" := x.apiKeyId,
      "appId" := x.appId,
    )
  }
  implicit val decoder: Decoder[WebApp] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("displayName")
      v1 <- c.get[Option[String]]("expireTime")
      v2 <- c.get[Option[String]]("etag")
      v3 <- c.get[Option[String]]("name")
      v4 <- c.get[Option[WebAppState]]("state")
      v5 <- c.get[Option[List[String]]]("appUrls")
      v6 <- c.get[Option[String]]("projectId")
      v7 <- c.get[Option[String]]("webId")
      v8 <- c.get[Option[String]]("apiKeyId")
      v9 <- c.get[Option[String]]("appId")
    } yield WebApp(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9)
  }
}
