package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class UndeleteWebAppRequest(
    /** Checksum provided in the WebApp resource. If provided, this checksum ensures that the client has an up-to-date value before proceeding.
      */
    etag: Option[String] = None,
    /** If set to true, the request is only validated. The App will _not_ be undeleted.
      */
    validateOnly: Option[Boolean] = None,
)
object UndeleteWebAppRequest {
  implicit val encoder: Encoder[UndeleteWebAppRequest] = Encoder.instance { x =>
    Json.obj("etag" := x.etag, "validateOnly" := x.validateOnly)
  }
  implicit val decoder: Decoder[UndeleteWebAppRequest] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[Boolean]]("validateOnly")
    } yield UndeleteWebAppRequest(v0, v1)

  }
}
