package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class UndeleteAndroidAppRequest(
    /** Checksum provided in the AndroidApp resource. If provided, this checksum ensures that the client has an up-to-date value before proceeding.
      */
    etag: Option[String] = None,
    /** If set to true, the request is only validated. The App will _not_ be undeleted.
      */
    validateOnly: Option[Boolean] = None,
)
object UndeleteAndroidAppRequest {
  implicit val encoder: Encoder[
    UndeleteAndroidAppRequest
  ] = Encoder.instance { x =>
    Json.obj("etag" := x.etag, "validateOnly" := x.validateOnly)
  }
  implicit val decoder: Decoder[
    UndeleteAndroidAppRequest
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[Boolean]]("validateOnly")
    } yield UndeleteAndroidAppRequest(v0, v1)
  }
}
