package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class StreamMapping(
    /** The resource name of the Firebase App associated with the Google Analytics data stream, in the format: projects/PROJECT_IDENTIFIER/androidApps/APP_ID or projects/PROJECT_IDENTIFIER/iosApps/APP_ID or projects/PROJECT_IDENTIFIER /webApps/APP_ID Refer to the `FirebaseProject` [`name`](../projects#FirebaseProject.FIELDS.name) field for details about PROJECT_IDENTIFIER values.
      */
    app: Option[String] = None,
    /** Applicable for Firebase Web Apps only. The unique Google-assigned identifier of the Google Analytics web stream associated with the Firebase Web App. Firebase SDKs use this ID to interact with Google Analytics APIs. Learn more about this ID and Google Analytics web streams in the [Analytics documentation](https://support.google.com/analytics/answer/9304153).
      */
    measurementId: Option[String] = None,
    /** The unique Google-assigned identifier of the Google Analytics data stream associated with the Firebase App. Learn more about Google Analytics data streams in the [Analytics documentation](https://support.google.com/analytics/answer/9303323).
      */
    streamId: Option[Long] = None,
)
object StreamMapping {
  implicit val encoder: Encoder[StreamMapping] = Encoder.instance { x =>
    Json.obj(
      "app" := x.app,
      "measurementId" := x.measurementId,
      "streamId" := x.streamId,
    )
  }
  implicit val decoder: Decoder[StreamMapping] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("app")
      v1 <- c.get[Option[String]]("measurementId")
      v2 <- c.get[Option[Long]]("streamId")
    } yield StreamMapping(v0, v1, v2)
  }
}
