package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class StatusProto(
    /** message_set associates an arbitrary proto message with the status. copybara:strip_begin(b/383363683) copybara:strip_end_and_replace optional proto2.bridge.MessageSet message_set = 5;
      */
    messageSet: Option[MessageSet] = None,
    /** Numeric code drawn from the space specified below. Often, this is the canonical error space, and code is drawn from google3/util/task/codes.proto copybara:strip_begin(b/383363683) copybara:strip_end_and_replace optional int32 code = 1;
      */
    code: Option[Int] = None,
    /** copybara:strip_begin(b/383363683) Space to which this status belongs copybara:strip_end_and_replace optional string space = 2; // Space to which this status belongs
      */
    space: Option[String] = None,
    /** copybara:strip_begin(b/383363683) copybara:strip_end_and_replace optional int32 canonical_code = 6;
      */
    canonicalCode: Option[Int] = None,
    /** Detail message copybara:strip_begin(b/383363683) copybara:strip_end_and_replace optional string message = 3;
      */
    message: Option[String] = None,
)
object StatusProto {
  implicit val encoder: Encoder[StatusProto] = Encoder.instance { x =>
    Json.obj(
      "messageSet" := x.messageSet,
      "code" := x.code,
      "space" := x.space,
      "canonicalCode" := x.canonicalCode,
      "message" := x.message,
    )
  }
  implicit val decoder: Decoder[StatusProto] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[MessageSet]]("messageSet")
      v1 <- c.get[Option[Int]]("code")
      v2 <- c.get[Option[String]]("space")
      v3 <- c.get[Option[Int]]("canonicalCode")
      v4 <- c.get[Option[String]]("message")
    } yield StatusProto(v0, v1, v2, v3, v4)
  }
}
