package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class Status(
    /** The status code, which should be an enum value of google.rpc.Code.
      */
    code: Option[Int] = None,
    /** A list of messages that carry the error details. There is a common set of message types for APIs to use.
      */
    details: Option[List[Map[String, Json]]] = None,
    /** A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
      */
    message: Option[String] = None,
)
object Status {
  implicit val encoder: Encoder[Status] = Encoder.instance { x =>
    Json.obj("code" := x.code, "details" := x.details, "message" := x.message)
  }
  implicit val decoder: Decoder[Status] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Int]]("code")
      v1 <- c.get[Option[List[Map[String, Json]]]]("details")
      v2 <- c.get[Option[String]]("message")
    } yield Status(v0, v1, v2)
  }
}
