package googleapis.firebase

import io.circe._

sealed abstract class ShaCertificateCertType(val value: String) extends Product with Serializable
object ShaCertificateCertType {

  /** Unknown state. This is only used for distinguishing unset values.
    */
  case object SHA_CERTIFICATE_TYPE_UNSPECIFIED
      extends ShaCertificateCertType("SHA_CERTIFICATE_TYPE_UNSPECIFIED")

  /** Certificate is a SHA-1 type certificate.
    */
  case object SHA_1 extends ShaCertificateCertType("SHA_1")

  /** Certificate is a SHA-256 type certificate.
    */
  case object SHA_256 extends ShaCertificateCertType("SHA_256")
  val values = List(SHA_CERTIFICATE_TYPE_UNSPECIFIED, SHA_1, SHA_256)
  def fromString(input: String): Either[String, ShaCertificateCertType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for ShaCertificateCertType")
  implicit val decoder: Decoder[ShaCertificateCertType] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[ShaCertificateCertType] = Encoder[String].contramap(_.value)
}
