package googleapis.firebase

import cats.effect.Concurrent
import org.http4s._
import org.http4s.implicits._
import org.http4s.client.Client

class ProjectsDefaultLocationClient[F[_]: Concurrent](client: Client[F])
    extends AbstractClient[F](client) {
  val baseUri = uri"https://firebase.googleapis.com/"
  def finalize(
      /** The resource name of the FirebaseProject for which the ["location for default Google Cloud resources"](https://firebase.google.com/docs/projects/locations#default-cloud-location) will be set, in the format: projects/PROJECT_IDENTIFIER Refer to the `FirebaseProject` [`name`](../projects#FirebaseProject.FIELDS.name) field for details about PROJECT_IDENTIFIER values.
        */
      parent: String
  )(input: FinalizeDefaultLocationRequest): F[Operation] = expectJson[Operation](
    requestWithBody(
      method = Method.POST,
      uri = baseUri / "v1beta1" / s"${parent}" / "defaultLocation:finalize",
    )(input)
  )
}
