package googleapis.firebase

import cats.effect.Concurrent
import org.http4s._
import org.http4s.implicits._
import org.http4s.client.Client

class ProjectsAndroidAppsShaClient[F[_]: Concurrent](client: Client[F])
    extends AbstractClient[F](client) {
  val baseUri = uri"https://firebase.googleapis.com/"
  def create(
      /** The resource name of the parent AndroidApp to which to add a ShaCertificate, in the format: projects/PROJECT_IDENTIFIER/androidApps/ APP_ID Since an APP_ID is a unique identifier, the Unique Resource from Sub-Collection access pattern may be used here, in the format: projects/-/androidApps/APP_ID Refer to the `AndroidApp` [`name`](../projects.androidApps#AndroidApp.FIELDS.name) field for details about PROJECT_IDENTIFIER and APP_ID values.
        */
      parent: String
  )(input: ShaCertificate): F[ShaCertificate] = expectJson[ShaCertificate](
    requestWithBody(method = Method.POST, uri = baseUri / "v1beta1" / s"${parent}" / "sha")(input)
  )
  def delete(
      /** The resource name of the ShaCertificate to remove from the parent AndroidApp, in the format: projects/PROJECT_IDENTIFIER/androidApps/APP_ID /sha/SHA_HASH Refer to the `ShaCertificate` [`name`](../projects.androidApps.sha#ShaCertificate.FIELDS.name) field for details about PROJECT_IDENTIFIER, APP_ID, and SHA_HASH values. You can obtain the full resource name of the `ShaCertificate` from the response of [`ListShaCertificates`](../projects.androidApps.sha/list) or the original [`CreateShaCertificate`](../projects.androidApps.sha/create).
        */
      name: String
  ): F[Empty] =
    expectJson[Empty](request(method = Method.DELETE, uri = baseUri / "v1beta1" / s"${name}"))
  def list(
      /** The resource name of the parent AndroidApp for which to list each associated ShaCertificate, in the format: projects/PROJECT_IDENTIFIER /androidApps/APP_ID Since an APP_ID is a unique identifier, the Unique Resource from Sub-Collection access pattern may be used here, in the format: projects/-/androidApps/APP_ID Refer to the `AndroidApp` [`name`](../projects.androidApps#AndroidApp.FIELDS.name) field for details about PROJECT_IDENTIFIER and APP_ID values.
        */
      parent: String
  ): F[ListShaCertificatesResponse] = expectJson[ListShaCertificatesResponse](
    request(method = Method.GET, uri = baseUri / "v1beta1" / s"${parent}" / "sha")
  )
}
