package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ProjectInfo(
    /** The user-assigned display name of the Google Cloud `Project`, for example: `My App`.
      */
    displayName: Option[String] = None,
    /** \*\*DEPRECATED\*\* _Instead, use product-specific REST APIs to work with the location of each resource in a Project. This field may not be populated, especially for newly provisioned projects after October 30, 2024._ The ID of the Project's ["location for default Google Cloud resources"](https://firebase.google.com/docs/projects/locations#default-cloud-location). The location is one of the available [Google App Engine locations](https://cloud.google.com/about/locations#region). Not all Projects will have this field populated. If it is not populated, it means that the Project does not yet have a location for default Google Cloud resources.
      */
    locationId: Option[String] = None,
    /** The resource name of the Google Cloud `Project` to which Firebase resources can be added, in the format: projects/PROJECT_IDENTIFIER Refer to the `FirebaseProject` [`name`](../projects#FirebaseProject.FIELDS.name) field for details about PROJECT_IDENTIFIER values.
      */
    project: Option[String] = None,
)
object ProjectInfo {
  implicit val encoder: Encoder[ProjectInfo] = Encoder.instance { x =>
    Json.obj(
      "displayName" := x.displayName,
      "locationId" := x.locationId,
      "project" :=
        x.project,
    )
  }
  implicit val decoder: Decoder[ProjectInfo] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("displayName")
      v1 <- c.get[Option[String]]("locationId")
      v2 <- c.get[Option[String]]("project")
    } yield ProjectInfo(v0, v1, v2)
  }
}
