package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class Operation(
    /** The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id}`.
      */
    name: Option[String] = None,
    /** The normal, successful response of the operation. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
      */
    response: Option[Map[String, Json]] = None,
    /** The error result of the operation in case of failure or cancellation.
      */
    error: Option[Status] = None,
    /** If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
      */
    done: Option[Boolean] = None,
    /** Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
      */
    metadata: Option[Map[String, Json]] = None,
)
object Operation {
  implicit val encoder: Encoder[Operation] = Encoder.instance { x =>
    Json.obj(
      "name" := x.name,
      "response" := x.response,
      "error" := x.error,
      "done" :=
        x.done,
      "metadata" := x.metadata,
    )
  }
  implicit val decoder: Decoder[Operation] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("name")
      v1 <- c.get[Option[Map[String, Json]]]("response")
      v2 <- c.get[Option[Status]]("error")
      v3 <- c.get[Option[Boolean]]("done")
      v4 <- c.get[Option[Map[String, Json]]]("metadata")
    } yield Operation(v0, v1, v2, v3, v4)
  }
}
