package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class Location(
    /** Products and services that are available in the location for default Google Cloud resources.
      */
    features: Option[List[LocationFeature]] = None,
    /** The ID of the Project's location for default Google Cloud resources. It will be one of the available [Google App Engine locations](https://cloud.google.com/about/locations#region).
      */
    locationId: Option[String] = None,
    /** Indicates whether the location for default Google Cloud resources is a [regional or multi-regional location](https://firebase.google.com/docs/projects/locations#types) for data replication.
      */
    `type`: Option[LocationType] = None,
)
object Location {
  implicit val encoder: Encoder[Location] = Encoder.instance { x =>
    Json.obj(
      "features" := x.features,
      "locationId" := x.locationId,
      "type" := x.`type`,
    )
  }
  implicit val decoder: Decoder[Location] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[LocationFeature]]]("features")
      v1 <- c.get[Option[String]]("locationId")
      v2 <- c.get[Option[LocationType]]("type")
    } yield Location(v0, v1, v2)
  }
}
