package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ListFirebaseProjectsResponse(
    /** If the result list is too large to fit in a single response, then a token is returned. If the string is empty, then this response is the last page of results. This token can be used in a subsequent calls to `ListFirebaseProjects` to find the next group of Projects. Page tokens are short-lived and should not be persisted.
      */
    nextPageToken: Option[String] = None,
    /** One page of the list of Projects that are accessible to the caller.
      */
    results: Option[List[FirebaseProject]] = None,
)
object ListFirebaseProjectsResponse {
  implicit val encoder: Encoder[
    ListFirebaseProjectsResponse
  ] = Encoder.instance { x =>
    Json.obj("nextPageToken" := x.nextPageToken, "results" := x.results)
  }
  implicit val decoder: Decoder[
    ListFirebaseProjectsResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("nextPageToken")
      v1 <- c.get[Option[List[FirebaseProject]]]("results")
    } yield ListFirebaseProjectsResponse(v0, v1)
  }
}
