package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ListAvailableLocationsResponse(
    /** One page of results from a call to `ListAvailableLocations`.
      */
    locations: Option[List[Location]] = None,
    /** If the result list is too large to fit in a single response, then a token is returned. If the string is empty, then this response is the last page of results and all available locations have been listed. This token can be used in a subsequent call to `ListAvailableLocations` to find more locations. Page tokens are short-lived and should not be persisted.
      */
    nextPageToken: Option[String] = None,
)
object ListAvailableLocationsResponse {
  implicit val encoder: Encoder[
    ListAvailableLocationsResponse
  ] = Encoder.instance { x =>
    Json.obj("locations" := x.locations, "nextPageToken" := x.nextPageToken)
  }
  implicit val decoder: Decoder[
    ListAvailableLocationsResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Location]]]("locations")
      v1 <- c.get[Option[String]]("nextPageToken")
    } yield ListAvailableLocationsResponse(v0, v1)
  }
}
