package googleapis.firebase

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scodec.bits.ByteVector

final case class IosAppConfig(
    /** The content of the XML configuration file.
      */
    configFileContents: Option[ByteVector] = None,
    /** The filename that the configuration artifact for the `IosApp` is typically saved as. For example: `GoogleService-Info.plist`
      */
    configFilename: Option[String] = None,
)
object IosAppConfig {
  implicit val encoder: Encoder[IosAppConfig] = Encoder.instance { x =>
    Json.obj(
      "configFileContents" := x.configFileContents,
      "configFilename" := x.configFilename,
    )
  }
  implicit val decoder: Decoder[IosAppConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ByteVector]]("configFileContents")
      v1 <- c.get[Option[String]]("configFilename")
    } yield IosAppConfig(v0, v1)
  }
}
