package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class FinalizeDefaultLocationRequest(
    /** \*\*DEPRECATED\*\* The ID of the Project's ["location for default Google Cloud resources"](https://firebase.google.com/docs/projects/locations#default-cloud-location), which are resources associated with Google App Engine. The location must be one of the available [Google App Engine locations](https://cloud.google.com/about/locations#region).
      */
    locationId: Option[String] = None
)
object FinalizeDefaultLocationRequest {
  implicit val encoder: Encoder[
    FinalizeDefaultLocationRequest
  ] = Encoder.instance(x => Json.obj("locationId" := x.locationId))
  implicit val decoder: Decoder[
    FinalizeDefaultLocationRequest
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("locationId")
    } yield FinalizeDefaultLocationRequest(v0)
  }
}
